<?php

/*

 Copyright (C) 2005 - 2006, Domeo / Avisi B.V.

 Website Baker inline wrapper module is free software; you can 
 redistribute it and/or modify it under the terms of the GNU 
 General Public License as published by the Free Software 
 Foundation; either version 2 of the License, or (at your 
 option) any later version.

 Website Baker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Website Baker; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**
 * @package pages
 *
 * Contents HTML page.
 */
class CssFile extends WebPage {

	/**
	 * Constructor.
	 *
	 * @param $pUrl string  The absolute URL.
	 */
	function CssFile($pUrl) {
		$this->WebPage($pUrl);
	}
	
	
	/**
	 * Display the CSS document
	 */
	function display() {
		
		$this->getContents();
		header("Content-Type: " . $this->contenttype);
		
		// Add some debugging
		$lDebugText = $this->cached ? "/* Inline wrapper: Cached version */" : "/* Inline wrapper: Fresh content */";
		
		print "\n\n" . $lDebugText . "\n\n" . $this->contents;
	}
	
	
	/**
	 * Rewrite css document for inline usage.
	 */ 
	function processDocument() {
	
		$lPath = $this->getPath();
		$lContents = $this->contents;
		
		// Rewrite style rules for use in div with id "wrapper".
		$lContents = preg_replace("'(^|})([^a-z^A-Z^\.^#^/]*)([^{]*){'si", "$1$2\n#wrapper $3{", $lContents);
		
		$lContents = preg_replace("',([^{^,^\n]+){'si", ",#wrapper $1{", $lContents);

		while (preg_match("',(?!#wrapper)([^,^{]+),'si", $lContents)) {
			$lContents = preg_replace("',(?!#wrapper)([^,^{]+),'si", ",#wrapper $1,", $lContents);
		}
		
		// convert relative links in stylesheet to absolute links.
		$lContents = preg_replace("'url\((?!http) *'si", "url(".$lPath."$1", $lContents);

		$this->contents = $lContents;
		$this->processed = true;		
	}
	
}

?>