<?php

/*

 Copyright (C) 2005 - 2006, Domeo / Avisi B.V.

 Website Baker inline wrapper module is free software; you can 
 redistribute it and/or modify it under the terms of the GNU 
 General Public License as published by the Free Software 
 Foundation; either version 2 of the License, or (at your 
 option) any later version.

 Website Baker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Website Baker; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// Global variable
global $IWCACHEDIR;
$IWCACHEDIR = WB_PATH . "/temp/inlinewrapper/";


/**
 * Do an HTML Post.
 *
 * @param $pUrl string           The full URL.
 * @param $pCookie string        (not required) Cookie string
 * @param $pPostVariables array  Array with HTTP POST variables.
 * @param $pHeaders array        (not required) Return headers
 * @return mixed                 False when not succesfull or the contents of the reply.
 */
function doPost ($pUrl, $pCookie = false, $pPostVariables, &$pHeaders) {
    
	// Add trailing slash, convert http://www.google.com to http://www.google.com/
	if (!str_contains("/", substr($pUrl, 8))) {
		$pUrl = $pUrl . "/";
	} 
	
	// Cut "http://". 
	$pUrl = substr($pUrl, 7);
	
	$lHost = substr($pUrl, 0, strpos($pUrl, "/"));
	$lAddress = substr($pUrl, strpos($pUrl, "/"));
	$lPort = 80;
	
	// Get portnumber if available.
	if (strpos($lHost, ":")) {
		$lPos = strpos($lHost, ":");
		$lPort = substr($lHost, $lPos + 1);
		$lHost = substr($lHost, 0, $lPos); 
	}
	
	$lHeaders  = "Referer: ".$_SERVER['HTTP_REFERER']."\r\n";
    $lHeaders .= "User-Agent: ".$_SERVER['HTTP_USER_AGENT']."\r\n";
    $lHeaders .= "X-Forward-IP: ".$_SERVER['REMOTE_ADDR']."\r\n";
    $lHeaders .= "Accept: text/html\r\n";
    $lHeaders .= "Accept-Charset: ISO-8859-1,utf-8\r\n";
    $lHeaders .= "Content-Type: application/x-www-form-urlencoded\r\n";
    $lHeaders .= "Connection: close\r\n";
    if ($pCookie !== false) {
        $lHeaders .= "Cookie: $pCookie\r\n";
    }
    
    // Convert postvariables
    $lContent = "";
	foreach ($pPostVariables as $lKey => $lValue) {
		$lContent .= ($lContent == "" ? "" : "&") . $lKey . "=" . urlencode($lValue);
	}
	$lHeaders .= "Content-Length: " . strlen($lContent);
		
	$lErrno = 0;
    $lErrstr = "";
    $lFp = @fsockopen ($lHost, $lPort, $lErrno, $lErrstr, 5);
    if (!$lFp) {
        echo "Error: $lErrstr ($lErrno)<br>\n";
        return false;
    }
    
    // We don't want to receive chunked data, that's why we use HTTP 1.0.
    $lContents = "";
    fputs ($lFp, "POST " . $lAddress . " HTTP/1.0\r\nHost: " . $lHost . ($lPort != 80 ? (":$lPort") : "") . "\r\n" . $lHeaders . "\r\n\r\n$lContent");
    socket_set_timeout ($lFp, 10, 0);
    while (!feof($lFp)) {
        $lContents = $lContents . fread ($lFp, 2048);
    }
    fclose ($lFp);

    // Split header and contents
    list($lHeaderBlok) = split("\n\r?\n", $lContents);

    // Parse headers
    if (is_array($pHeaders)) {
    	$lHeaders = explode("\n", $lHeaderBlok);
    	$pHeaders['status'] = $lHeaders[0];
    	for ($i=1; $i<sizeOf($lHeaders); $i++) {
    		list($lKey, $lValue) = explode(': ', $lHeaders[$i]);
    		// ignore extra \r.
    		if ($lKey != "" && $lValue != "") {
    			$pHeaders[strtolower(trim($lKey))] = trim($lValue);
    		}
    	}
    }

    // De content 
    return substr($lContents, strlen($lHeaderBlok));
}


/**
 * Do an HTTP Get request.
 *
 * @param $pUrl string            Full URL, ie "http://www.google.com/translate/index.html".
 * @param $pRequestHeaders array  Headers to add in request.
 * @param $pCookie string         (not required) Cookie string
 * @param $pHeaders array         (not required) Return headers
 * @param $pContent boolean       If false, then do a HEAD request otherwise do a real GET request.
 * @return mixed                  False when not succesfull or the contents of the reply.
 */
function doGet ($pUrl, $pRequestHeaders = false, $pCookie = false, &$pHeaders, $pContent = true) {
	
	// Add trailing slash, convert http://www.google.com to http://www.google.com/
	if (!str_contains("/", substr($pUrl, 8))) {
		$pUrl = $pUrl . "/";
	} 
	
	// Cut "http://". 
	$pUrl = substr($pUrl, 7);
	
	$lHost = substr($pUrl, 0, strpos($pUrl, "/"));
	$lAddress = substr($pUrl, strpos($pUrl, "/"));
	$lPort = 80;
	
	// Get portnumber if available.
	if (strpos($lHost, ":")) {
		$lPos = strpos($lHost, ":");
		$lPort = substr($lHost, $lPos + 1);
		$lHost = substr($lHost, 0, $lPos); 
	}

    $lHeaders  = "Referer: ".$_SERVER['HTTP_REFERER']."\r\n";
    $lHeaders .= "User-Agent: ".$_SERVER['HTTP_USER_AGENT']."\r\n";
    $lHeaders .= "X-Forward-IP: ".$_SERVER['REMOTE_ADDR']."\r\n";
    $lHeaders .= "Accept: text/html\r\n";
    $lHeaders .= "Accept-Charset: ISO-8859-1,utf-8\r\n";
    $lHeaders .= "Connection: close\r\n";
    if ($pCookie !== false) {
        $lHeaders .= "Cookie: $pCookie\r\n";
    }

    // Add extra headerfields to request.
    if ($pRequestHeaders !== false) {
    	for ($i = 0; $i < sizeof($pRequestHeaders); $i++) {
    		$lHeaders .= $pRequestHeaders[$i] . "\r\n";
    	}
    }

    $lErrno = 0;
    $lErrstr = "";
    $lFp = @fsockopen ($lHost, $lPort, $lErrno, $lErrstr, 5);
    if (!$lFp) {
        echo "Error: $lErrstr ($lErrno)<br>\n";
        return false;
    }

    // We don't want to receive chunked data, that's why we use HTTP 1.0.
    $lContents = "";
    fputs ($lFp, ($pContent ? "GET" : "HEAD") . " $lAddress HTTP/1.0\r\nHost: $lHost" . ($lPort != 80 ? (":$lPort") : "") . "\r\n$lHeaders\r\n");
    socket_set_timeout ($lFp, 10, 0);
    while (!feof($lFp)) {
        $lContents = $lContents . fread ($lFp, 2048);
    }
    fclose ($lFp);

    // Split header and contents
    list($lHeaderBlok) = split("\n\r?\n", $lContents);

    // Parse headers
    if (is_array($pHeaders)) {
    	$lHeaders = explode("\n", $lHeaderBlok);
    	$pHeaders['status'] = $lHeaders[0];
    	for ($i=1; $i<sizeOf($lHeaders); $i++) {
    		list($key,$value) = explode(': ', $lHeaders[$i]);
    		// Ignore extra \r.
    		if ($key!='' && $value != '') {
    			$pHeaders[strtolower(trim($key))] = trim($value);
    		}
    	}
    }

    // The contents part
    return substr($lContents, strlen($lHeaderBlok));
}


// ==========================================================
// File functions
// ==========================================================


/**
 * Convert illegal filename chars to _
 *
 * @param $pFileName string  Filename to convert.
 * @return string            Rewritten filename.
 */
function safe_filename ($pFileName) {
	return preg_replace("'[^a-zA-Z0-9_.-]+'", '_', $pFileName);
}


/**
 * Function to make recursive folder delete possible
 * 
 * @param string $dirname  Directory to delete
 * @return True if success
 */
function rmdir_recursive($dirname) {
	$dir=@opendir($dirname);
	if (!$dir) {
		return false;
	}
	while ($file=readdir($dir)) {
		if ($file == "." || $file == "..") {
			continue;
		}
		$path = $dirname . "/" . $file;
		if (is_file($path)) {
			@unlink($path);
		} elseif(is_dir($path)) {
			rmdir_recursive($path);
		}
	}
	closedir($dir);
	rmdir($dirname);
}


/**
 * Delete files older than x m seconds
 *
 * @param string $dirname  Directory to check
 * @param int $age         Minimum age in seconds
 */
function rm_cache_files($dirname, $age) {

	$handle = opendir($dirname);
	$time = time();

	while ($file = readdir($handle)) {
		if ($file != "." && $file != "..") {

			$file = "$dirname/$file";
			$filetime = @filemtime($file);
			if ($filetime && ($time - $filetime) > $age) {
				@unlink($file);
			}
		}
	}

	// Close the directory handle
	closedir($handle);
}


/**
 * Remove files given in array. Ignore errors and warnings.
 *
 * @param array $files Files to delete
 */
function rm_files($files) {
	if (is_array($files)) {
		foreach ($files as $file) {
			@unlink($file);
		}
	}
}


// ==========================================================
// String functions
// ==========================================================


/**
 * Java like String endsWith() function.
 *
 * @param string $pNeedle    String to search for.
 * @param string $pHayStack  String to search in.
 * @return boolean           True if endswith given string.
 */
function str_endswith($pNeedle, $pHayStack) {
	return substr($pHayStack, strlen($pNeedle) * -1) == $pNeedle;
}


/**
 * Java like String startsWith() function.
 *
 * @param string $pNeedle    String to search for.
 * @param string $pHayStack  String to search in.
 * @return boolean           True is startswith given string.
 */
function str_startswith($pNeedle, $pHayStack) {
	return strpos($pHayStack, $pNeedle) === 0;
}


/**
 * Java like String contains function.
 *
 * @param string $pNeedle    String to search for.
 * @param string $pHayStack  String to search in.
 * @return boolean           True if haystack string contains needle.
 */
function str_contains($pNeedle, $pHayStack) {
	return strpos($pHayStack, $pNeedle) !== false;
}

?>