/*
 *  Copyright (C) <2005>  <Steve Woodcock>
 *  
 * Created on Jun 5, 2005
 *
 */
package com.jofti.api;


/**
 * Provides an interface for all Indexes so that the cache implementation
 * is always accessable if any implementation specific methods need to be called.
 * <p>
 * Note: mutator methods called using the Cache directly will not update the index, unless using 
 * a listener Adapter, and
 * will result in the index and cache becoming out of synch.
 * <p>
 *  @author Steve Woodcock<br>
 *	@version 1.5<br>
 */
public interface CacheAccessor {
	
	 /**
	  * Obtains the underlying cache implementation.<br>
	 * @return the cache implementation.
	 */
	public Object getCacheImpl();
	

	
}
