/*
 * Copyright (C) <2005>  <Steve Woodcock>
 *
 * Created on 01 June 2003, 08:12
 */

package com.jofti.api;

import java.util.Map;

import com.jofti.exception.JoftiException;

/**
 *
 *
 * This interface is used as the base interface for Indexes. The index is only 
 * searchable via the query method and is not available for direct manipulation.
 * <p>
 * The index does not require that all keys used are of the same type. It is reasonable to
 * use many different key types. The only restriction is that the key must implement 
 * hashCode() and equals() if the searches are to work properly (as you would expect for HashMap).
 * <p>
 * Additionally, some caches have restrictions on key types:
 * OSCache requires all keys to be String
 * EHcache requires the key to be Serializable.
 * <p>
 * In general usage it is highly recommended (but not required) that you use keys that also implement 
 * Comparable. 
 * <p>
 * @author  Steve Woodcock<br>
 * @version 1.7<br>
 * 
 * 
 */
public interface Index {
    
     
    /**
     * This queries the index and retrieves a map of matching elements (if any). The map contains 
     * key/value pairs of the key in the cache and the value stored against it. If ordering is specified in the
     * query then the iterator provides ordered access to the return values.
     * <p>
     * If you are using a NameSpacedIndex the keys returned 
     * in this map are of type @see NameSpaceKey. 
     * <p>
     * @param query - the type of query to perform against the index and cache.
     * @return Map a map of the key/value results<br>
     * @throws JoftiException a wrapper exception for errors in the query. <br>
     */
    public Map query(IndexQuery query) throws JoftiException;
     
       
    
    /**
     * Adds a Query to the Index. Currently, This only supports EJB or SQL format queries 
     * not the convenience queries. 
     * @param name - the name that the query is stored under.
     * @param query - the query to be stored in the index.
     * @return - The parsed query.
     * @throws JoftiException - Thrown if the query is not able to be parsed.
     */
    public IndexQuery addQuery(String name, IndexQuery query) throws JoftiException ;
    
    
    /**
     * Obtains a previously stored query, whether stored programmatically or in a config file. 
     * Returns NULL if the query does not exist in the Index.
     * @param name
     * @return Query or NULL if no query is stored under the name.
     */
    public IndexQuery getQuery(String name)  ;
    
    
    
}
