/*
 *  Copyright (C) <2005>  <Steve Woodcock>
 *
 * Created on 01 June 2003, 08:12
 */

package com.jofti.api;

import com.jofti.exception.JoftiException;

/**
 * The main interface used by clients of index wrappers that are not Name Spaced.
 * <p>
 * The interface uses similar methods to the Map interface as most cache implementations 
 * can be easily adapted to these methods.<p>
 * 
 * As with the Map classes the metaphors are to add an object use the put method, to retrieve an 
 * object use get(key) and to remove use remove(key).
 * <p>
 * The additional query method is for clients to query the cache by values other than the key. Please refer to 
 * the docs on IndexQuery.
 * <p>
 *  It is important to realise that although the interface takes an Object as both key and value, some caches will only 
 * allow certain types of Objects to be inserted. Check with the actual cache provider used to determine
 * these limitations.
 * <p>
 * The usage to obtain a cache is to create a com.jofti.manager.IndexManager then use the 
 * getIndexCache method to obtain a reference to the index. Where a listener implementation is available it is 
 * recommended to configure a listener adapter and perform the puts/gets directly on the cache implementation. This Inteface should be used 
 * where you want to be able to swap cache implmentations with no code change or you need to use a cache, such as Map, that has no callback capability. 
* <p>
 * 
 *  
 * @author  Steve Woodcock (steve@jofti.com)<br>
 * @version 1.3<br>
 * 
 */
public interface IndexCache extends CacheAccessor, Index{
    
    /**
     * Puts an object into the underlying cache instance and indexes the object according to
     * the class definitions in the index config file. Some caches may only accept certain types of 
     * object.<p>
     * @param key value to use as key in cache
     * @param value value to put into cache and to be indexed
     * @throws JoftiException thrown as a wrapper exception that contains any cache specific exceptions.
     */
    public void put(Object key, Object value) throws JoftiException;
        
    /**
     * Retrieves an object from the underlying cache instance. The behaviour of the caches have 
     * been normalised so that a not found object will always return null - rather than throw an exception (as some caches do). A cache error
     * (if any) will be tranformed into a log message only. 
     * <p>
     * @param key  -the key to retrieve the cached object
     * @return the object mapped in the cache - or null if no object found.
     */
    public Object get(Object key);
    
    /**
     * Deletes an object from the underlying cache. Attempting to remove a non-existent, or expired object will 
     * not generate an exception. Note: this behaviour has been normalised so that all caches appear conform to this idipom.
     *  This will also remove the key/object from the index.
     * <p>
     * @param key  -the key to retrieve the cached object
     * @throws JoftiException - A wrapper for any cache specific exceptions or exceptions generated by the index.
     */
    public void remove(Object key) throws JoftiException;
    
    /**
     * This will remove all the values in the cache and dump the current index.<p>
     * @throws JoftiException
     */
    public void removeAll() throws JoftiException;
    
   
  
    
    
}
