/*
 * Copyright (C) <2005>  <Steve Woodcock>
 * Created on 07-Oct-2004
 *
 */
package com.jofti.api;

/**

 *
 * Root interface for query objects. All IndexQueries will implement this interface, but not all are required 
 * to provide implementations of the optional parameter setting methods.<p>
 * 
 * @author Steve Woodcock<br>
 * @version 1.7<p>
 */
public interface IndexQuery {

	/**
	 * <p>
	 * Sets a parameter on a Query by name. The name should match a String representation of the 
	 * parameter in the query implementation. The format of the name is defined by the type of query. 
	 * </p>
	 * <p>
	 * The method returns the IndexQuery in order to allow method chaining for parameter setting.
	 * </p>
	 * @param name - the name for the parameter.
	 * @param value - the Object that is used to bind to the parameter.
	 * @return - The indexQuery that the parameter was set on.
	 */
	public IndexQuery setParameter(String name, Object value);
	
	/**
	 * <p>
	 * Sets a parameter on a Query by name. The name should match the numeric position of the 
	 * parameter in the query implmentation. The format of the name is defined by the type of query. 
	 * </p>
	 * <p>
	 * The method returns the IndexQuery in order to allow method chaining for parameter setting.
	 * </p>
	 * @param position - the position for the parameter.
	 * @param value - the Object that is used to bind to the parameter.
	 * @return - The indexQuery that the parameter was set on.
	 */
	public IndexQuery setParameter(int position, Object value);
	
	
	/**
	 * <p>
	 * Sets a maximum number of results to return in the query. If the results are not ordered then 
	 * repeated calling of the method could return different results irrespective of data changes.
	 * </p>
	 * <p>
	 * When ordering is set repeated calls with this value set will return the same results providing 
	 * that the data has not changed. However, in order to provide ordering the full result set must 
	 * be evaluated and are therefore loaded into memory. The results falling outside the return range will then be discarded.
	 * </p>
	 * <p>
	 * A negative value will return a runtime IllegalArgumentException. Zero is equivalent to all results. Setting the value to more than 
	 * the number of results found will results in all results being returned.
	 * The method returns the IndexQuery in order to allow method chaining for parameter setting.
	 * </p>
	 * @param maxResults - the maximum number of results to return. 
	 * @return - The indexQuery that the parameter was set on.
	 */
	public IndexQuery setMaxResults(int maxResults);
	
	/**
	 * <p>
	 * Sets the first result number to be returned. If this is used in conjunction with maxResults then a paging type 
	 * mechanism can be emulated (providing the results are ordered). A negative value will result in a runtimeException and setting the value 
	 * larger than the number of results will result in zero results returned.
	 * </p>
	 * <p>
	 * The method returns the IndexQuery in order to allow method chaining for parameter setting.
	 * </p>
	 * @param firstResult - the position of the first result - this is 0 indexed.
	 * @return - The indexQuery that the parameter was set on.
	 */
	public IndexQuery setFirstResult(int firstResult);
	
}
