/*
 * Copyright (C) <2005>  <Steve Woodcock>
 * Created on Jun 10, 2005
 *
 */
package com.jofti.api;


/**
 
 *
 * This is used to wrap the key objects used in caches that are name space aware, such 
 * as JBossCache. The NameSpaceKey object is returned from queries as the key object in the result map.
 * There is an implicit ordering by nameSpace and then by the key.<p>
 * 
 * The ordering is defined by (as pseudocode)<br>
 *  if nameSpace instance of comparable && namespace.class == other.class <br>
 *  then use namespace.compareTo(other)<br>
 *  else use comparison of namespace.toString().compareTo(other.toString()).<br>
 * <p>
 *  So for namespaces that are the same type and implement comparable then 
 * a correct ordering will occur otherwise you will get a lexical ordering
 * based on the toString() method.
 * <p>
 * It is recommended that you use namspaces that are the same type.
 * <p>
 * The keys are compared in a similar manner.<p>
 * 
 * @author Steve Woodcock<br>
 * @version 1.5
 */
public interface NameSpaceKey extends Comparable{

	/**
	 * Gets the namespace part of the NameSpaceKey. The object is dependent upon the Cache implementation used.
	 * @return - the nameSpace.
	 */
	public Object getNameSpace();
	
	/**
	 * Gets the key part of the NameSpaceKey.
	 * @return - the key under which the object was stored..
	 */
	public Object getKey();
}
