/*
 * Copyright (C) <2005>  <Steve Woodcock>
 * 
 * Created on 09 May 2003, 13:22
 */
package com.jofti.btree;





/**
 * Abstract base class for leaf node variations<p>
 * 
 * @author Steve Woodcock<br>
 * @version 1.9<br>
 */
abstract class AbstractLeafNode extends Node implements Leaf {


	protected NodeLink nextNode = null;

	protected IndexNodeEntry parentKey = null;

	protected boolean deleted = false;

	protected Comparable rightValue;

	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	

	/** Creates a new instance of LeafNode */
	AbstractLeafNode() {
	}

	/**
	 * Resets the next node if the current next node that it points to is marked as deleted 
	 * (no entries and marked as deleted). This allows the garbage to collect the node and effectively
	 *  means that the node is deleted from the Tree.<p>
	 */
	protected void resetNextNode() {
		if (nextNode != null && nextNode.getNode() != null
				&& nextNode.getNode().isDeleted()) {
			nextNode = nextNode.getNode().getLinkNode();
		}
	}



	/**
	 * A specific binary search method for the leaf node. This adapted from the standard binary
	 * search implementation in the Collections API.<p>
	 * 
	 * Note need to investigate the use of the Uniform Binary Search variations in Knuth Soting and searching.
	 * <p>
	 * @param list1 - the list to search<br>
	 * @param obj - the object to find <br>
	 * @return A leafnodeEntry if one is matched - otherwise null;
	 */
	protected LeafNodeEntry indexedBinaryRetrieve(Object[] list1,  Object obj) {
		int i = 0;
        int size = entryNumber;
		for (int j =  size- 1; i <= j;) {
			int k = i + j >> 1;
			LeafNodeEntry obj1 = (LeafNodeEntry)list1[k];
			int l =  obj1.getValue().compareTo(obj);
			if (l < 0)
				i = k + 1;
			else if (l > 0)
				j = k - 1;
			else
				return obj1;
		}

		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.jofti.btree.Node#getLinkNode()
	 */
	public NodeLink getLinkNode() {

		return nextNode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.jofti.btree.Node#setLinkNode(com.jofti.btree.Node)
	 */
	public void setLinkNode(NodeLink node) {
		this.nextNode = node;

	}

	/**
     * Check whether the node has been marked as deleted.<p>
     * 
	 * @return Returns whether the node has been marked as deleted.
	 */
	public boolean isDeleted() {
		return deleted;
	}

	/**
     * Sets a node to be deleted.<p>
	 * @param deleted sets the node to be deleted.
	 */
	public void setDeleted(boolean deleted) {
		this.deleted = deleted;
	}

	
	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#getRightValue()
	 */
	public Comparable getRightValue() {
		
			return rightValue;
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#setRightValue(java.lang.Comparable)
	 */
	public void setRightValue(Comparable value) {
		this.rightValue = value;
		
	}

	

	

	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#getEntryNumber()
	 */
	public int getEntryNumber() {
		return entryNumber;
	}


	/* (non-Javadoc)
	 * @see com.jofti.btree.Leaf#getEntry(java.lang.Comparable)
	 */
	public LeafNodeEntry getEntry(Comparable value) {
		if (entryNumber ==0)
		{
			return null;
		}
		
		// look through list and see if we have a match
		
		return indexedBinaryRetrieve(realGetEntries(), value);
		
		
	
			
			
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#isUnderFull()
	 */
	public boolean isUnderFull() {
		if (entryNumber < BTree.getMaxNodeSize())
		{
			return true;
		}
		return false;
	}

	
	
	
	protected abstract Object[] realGetEntries();
	
	

	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#isEmpty()
	 */
	public boolean isEmpty() {
		return entryNumber ==0;
	}
}