/*
 * Created on 07-Oct-2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.jofti.btree;



import com.jofti.exception.JoftiException;
import com.jofti.oswego.concurrent.ReadWriteLock;


/**

 * The interface for Nodes (both internal and leaf) in the BTree.<p>
 * 
 * @author Steve Woodcock<br>
 * @version 1.8
 */
public interface INode {
	
	
	/**
	 * Gets the rightmost value for the node. This represents the largest value that this node (or its children) 
	 * know about.
	 * 
	 * @return The right value.
	 */
	public abstract Comparable getRightValue();


	
	/**
	 * Sets the right value for the node.
	 * 
	 * @param value - the value to use.
	 */
	public abstract void setRightValue(Comparable value);



	public abstract boolean contains(Comparable value);


	
	/**
	 * 
	 * Inserts the entry into the correct position in the node. The position is ordered by 
	 * the Comparableness of its value.  If the value in the entry already exists then a 
	 * new Entry is not created, it will be added to a leaf node as a member of an existing entry.
	 * <p> If the value is larger than the current right value for the node then the right value is updated.<p>
	 * @param entry - the entry to set.
	 * @return - true if the new Entry required a new entry to be added to the list.
	 * @throws JoftiException
	 */
	public abstract Object[] insertEntry(NodeEntry entry) throws JoftiException;


	/**
	 * Removes an entry from the list of entries in the Node.<p> If the deleted node is the current right value, then the right 
	 * value is updated with the next lowest value in the node.<p>
	 * 
	 * @param entry - the entry to remove. 
	 * @return if a matching entry was found to remove.
	 */
	public abstract boolean deleteEntry(NodeEntry entry);



	/**
	 * Splits the current node into two new nodes. The two nodes have a 50/50 split of the entries distributed among them. The higher set 
	 * are contained in the new node. In addition, the right values of each node are reset and the next node links are updated. The existing node's 
	 * next node link is pointing the the new node and the new node is pointing to the previous right neighbour of the existing node. 
	 * <p>
	 * @return the new Node containing half of the existing node's values.
	 */
	public abstract Node splitNode(Object[] entries) throws JoftiException;


	/**
	 * Retrieves the number of entries in the node.<br>
	 * @return entry number.
	 */
	public abstract int getEntryNumber();


	/**
	 * Used to check if the node has exceeded or equaled the maximum number of allowed entries. This is used to 
	 * decide whether to spilt the node as part of the insert node functions.
	 * 
	 * @return If the number of entries is >= maximum allowed entries.
	 */
	public abstract boolean isUnderFull();


	/**
	 * Checks if the node has any entries.<p>
	 * 
	 * @return true if the node has no entries.
	 */
	public abstract boolean isEmpty();


	/**
	 * Checks whether a node has been marked as deleted as a result of a remove. A node is only marked as deleted if it become empty. 
	 * At some time later it will then be removed from the tree as other threads traverse it.<p>
	 * @return true if marked as deleted.
	 */
	public abstract boolean isDeleted();


	/**
	 * Sets a node to be deleted. The node is <b>not</b> removed from the tree instead the other threads in the tree 
	 * will remove a deleted node as part of their normal traversal process.<p>
	 * @param deleted
	 */
	public abstract void setDeleted(boolean deleted);


	/**
	 * Retrieves the entries in the node as an array. 
	 * @return the object array for the entries.
	 */
	public abstract Object[] getEntries();


	/**
	 * Replaces the current entries with a new list of entries. The list passed in is shallow copied 
	 * so changes to the originla list do not affect the list in the Node.
	 * <p>
	 * @param entries
	 */
	public abstract void setEntries(Object[] entries);


	/**
	 * Returns the sibling righthand node for this node. This is part of the linking mechanism used to provide 
	 * concurrency in the tree.<p>
	 * 
	 * @return A nodelink containing the sibling node.
	 */
	public abstract NodeLink getLinkNode();


	/**
	 * Sets a new right hand link for this node.<p>
	 * 
	 * @param node - the nodelink to set as the right hand sibling.
	 */
	public abstract void setLinkNode(NodeLink node);


	/**
	 * @return Returns the nodeLock.
	 */
	public abstract ReadWriteLock getNodeLock();
	
	public abstract boolean isLeaf();
}