/*
 * Created on 20-Mar-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.btree;

import java.nio.ByteBuffer;


import com.jofti.core.IStoreManager;

/**
 * <p>
 * Defines the operations for a disk page. The page wraps the structure of the entries allowing 
 * flexibility in usage in the nodes.
 * </p>
 * @author xenephon
 * @version 1.2
 */
public interface IPage {
	
	/**
	 * Returns the entry at the specified position or null if none exists.
	 * @param position
	 * @return The leafNode Entry.
	 */
	public LeafNodeEntry getEntry(int position);

	/**
	 * <p>
	 * Sets an entry at the specified position. The current entry (if any) and adjacent entries are shuffled up by a position of
	 * 1.
	 * </p>
	 * @param position
	 * @param entry
	 */
	public void setEntry(int position, LeafNodeEntry entry);

	/**
	 * Removes an entry at the specified position. Larger entries are shuffled down by 1 position.
	 * @param position
	 */
	public void removeEntry(int position);

	public void updateEntry(int location, LeafNodeEntry entry);

	public ByteBuffer copyBuffer(ByteBuffer newBuf);

	public void reset();
	
	public ByteBuffer getBuffer();
	
	public int[] getPointers();
	
	public void setManager(IStoreManager manager);
	

}