/*
 * Created on 07-Oct-2004
 *
 */
package com.jofti.btree;

import java.util.Collection;

/**
 *
 * The node returned from the tree that contains the data from the real node that was a result of the search. It is really 
 * a wrapper object to a snapshot of the real node's  entry list and the sibling node links. This node is immutable and changes to the underlying node are not reflected in the result node.
 * <p>
 * @author Steve Woodcock<br>
 * @version 1.5<br> 
 */
public interface IResultNode extends INode {

	/**
	 * Returns the leaf node Entry that matches the value, or null if none found.
	 * 
	 * @param value - the value to change.
	 * @return - a leaf node entry or Null.
	 */
	LeafNodeEntry getEntry(Comparable value);
	
		
	/**
	 * Returns the entries (if any) that are smaller than the value in the node.
	 * <p>
	 * @param value - 
	 * @return a list of leaf node entries, or an empty list if none found.
	 */
	Collection getEntriesBefore(Comparable value);
	
	
}
