/*
 * IndexKey.java
 *
 * Created on 09 May 2003, 15:07
 */

package com.jofti.btree;

/**
 * 
 * An entry for the internal node structures.<p>
 *
 * @author  Steve Woodcock<br>
 * @version 1.0<br>
 */
class IndexNodeEntry implements NodeEntry {
    
    /**
     * 
     */
    private static final long serialVersionUID = 6905415196213618087L;
    
    private Node childNode = null;
    private Node containingNode = null;
    Comparable value=null;
    
    private volatile int  hashCode =0;
    
    
    /** Creates a new instance of IndexNodeEntry */
    IndexNodeEntry() {
    }
    

    
   void updateValue(){
   		this.value = childNode.getRightValue();
   }
   
    
    /** Getter for property childNode.
     * @return Value of property childNode.
     *
     */
    Node getChildNode() {
        return childNode;
    }
    
    /** Setter for property childNode.
     * @param childNode New value of property childNode.
     *
     */
    void setChildNode(Node childNode) {
        this.childNode = childNode;
    }
    
    
    /** Getter for property containingNode.
     * @return Value of property containingNode.
     *
     */
    Node getContainingNode() {
        return containingNode;
    }
    
    /** Setter for property containingNode.
     * @param containingNode New value of property containingNode.
     *
     */
    void setContainingNode(Node containingNode) {
        this.containingNode = containingNode;
    }
    
    /** Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.<p>
     *
     * In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of <i>expression</i>
     * is negative, zero or positive.
     *
     * The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)<p>
     *
     * The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.<p>
     *
     * Finally, the implementer must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.<p>
     *
     * It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     *
     * @param   o the Object to be compared.
     * @return  a negative integer, zero, or a positive integer as this object
     * 		is less than, equal to, or greater than the specified object.
     *
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     *
     */
    public int compareTo(Object o) 
    {

        return value.compareTo(((IndexNodeEntry)o).value);

    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object o) 
    {
        if (o instanceof IndexNodeEntry) 
        {
             return compareTo((IndexNodeEntry)o) == 0;
        } else {
            return false;
        }
    }
 
    
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode(){
    	if (hashCode ==0){
    		int result = 17;
    		result = 37*result + value.hashCode();
    		hashCode = result;
    	}
    	return hashCode;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" Value:" + value);
        buf.append(" ChildNode:" + childNode);
        return buf.toString();
    }







	/* (non-Javadoc)
	 * @see com.jofti.btree.NodeEntry#getValue()
	 */
	public Comparable getValue()
	{
		return value;
	}







	/* (non-Javadoc)
	 * @see com.jofti.btree.NodeEntry#setValue(java.lang.Comparable)
	 */
	public void setValue(Comparable value)
	{
		this.value = value;
		
	}
    
}
