package com.jofti.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

/**
 * Represents a valueObject that stores a key in the cache. The definition also includes a Map of the attributes 
 * the object has in order to be able to identify which attributes an object has when it is entered into the cache.
 * 
 * @author steve Woodcock
 * @version 1.5
 */
final public class KeyValueObject extends ValueObject implements Externalizable{


    private static final long serialVersionUID = -4721473999348297006L;
    protected Map attributes;
	
	public KeyValueObject() {
	    }
	
	public KeyValueObject(int dimension, Comparable value, Map attributes) {
       super(dimension,value);
       this.attributes = attributes;
    }

	public  Map getAttributes() {
		return attributes;
	}

	public  void setAttributes(Map attributes) {
		this.attributes = attributes;
	}
	
	 public String toString(){
	        StringBuffer buf = new StringBuffer();
	        buf.append("dimension:" + dimension);
	        buf.append(", real Value:" + realValue);
	        buf.append(", dimension:" + attributes);
	        return buf.toString();
	    }
	 
	 public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
			dimension = in.readInt();
			realValue = (Comparable)in.readObject();			
			attributes = (Map)in.readObject();
			
		}

		public void writeExternal(ObjectOutput out) throws IOException {
			out.writeInt(dimension);
			out.writeObject(realValue);
			out.writeObject(attributes);
			
		}
}
