/*
 * LeafNode.java
 * 
 * Created on 09 May 2003, 13:22
 */
package com.jofti.btree;
import com.jofti.exception.JoftiException;



/**
 * The Implementation of a LeafNode. The node stores a list of LeafNodeEntries.
 * <p>
 * 
 * @author Steve Woodcock
 * @version 1.0<br>
 */ 
class LeafNode extends AbstractLeafNode implements Leaf{

	 protected Object[] entries = null;
	 

	
	/** Creates a new instance of LeafNode */
	LeafNode()
	{
	}
	
	
	


	public String toString()
	{
		StringBuffer buf = new StringBuffer();
		buf.append(" LeafNode{");
		Object[] tempEntries =entries;
		for (int i = 0; i < entryNumber; i++)
		{
			buf.append(" Entry:" + tempEntries[i]);
		}

		buf.append("} ");
		return buf.toString();
	}



	public Object[] insertEntry(NodeEntry entry) throws JoftiException {
		Object[] tempEntries =entries;
		if (entry == null || entry.getValue() ==null){
			throw new JoftiException("Null node entry cannot be inserted");
		}
		
		resetNextNode();
		if (entryNumber == 0)
		{
			tempEntries[0]=entry;
			entryNumber++;
			rightValue=entry.getValue();
			return tempEntries;
		} else if (rightValue.compareTo(entry.getValue()) >=0)
		{
				
			int result = indexedBinaryLocate(tempEntries, entry);
			
			if (result <0){
				// we need to insert it
				int index = (-result)-1;
					if (index <= entryNumber){
					System.arraycopy(tempEntries, index, tempEntries, index + 1,
	            			entryNumber - index);
					tempEntries[index] = entry;
					
				}else{
					tempEntries[entryNumber]=entry;
				}
					entryNumber++;
				return tempEntries;
			} else{
				LeafNodeEntry listEntry =(LeafNodeEntry) tempEntries[result];
				listEntry.addUniqueIdSet(((LeafNodeEntry)entry).getUniqueIdSet());
				return tempEntries;
			}
		
		} 
			throw new JoftiException("unable to insert " + entry.getValue()+ "as is bigger than current right value");
		
	}


	  protected  int indexedBinaryLocate(Object[] list1, Object obj)
	    {
		  
		  int low = 0;
			int high = entryNumber-1;
			
			LeafNodeEntry entry =null;
			while (low <= high) {
			    int mid = (low + high) >> 1;
			    
			    entry = (LeafNodeEntry)list1[mid];
	            int cmp = entry.compareTo(obj);

			    if (cmp < 0)
				low = mid + 1;
			    else if (cmp > 0)
				high = mid - 1;
			    else
				return mid; // key found
			}
			return -(low + 1);  // key not found

	    }

	
	public boolean deleteEntry(NodeEntry entry) {
		resetNextNode();
		Object[] tempEntries =entries;
		
		if (entry == null || entry.getValue() ==null){
			return false;
		}
		if (entryNumber == 0)
		{
			return false;
		} else
		{
			int result = indexedBinaryLocate(tempEntries, entry);
			if (result >=0){
				LeafNodeEntry listEntry = (LeafNodeEntry)tempEntries[result];
				
				listEntry.removeAllIds(((LeafNodeEntry)entry).getUniqueIdSet());
				
				if (listEntry.getUniqueIdSize() ==0){
					int numMoved = entryNumber - result - 1;
	            	if (numMoved > 0)
	            	    System.arraycopy(tempEntries, result+1, tempEntries, result,
	            			     numMoved);
	            	tempEntries[--entryNumber] = null; // Let gc do its work
					
					// update the right value if we need to
					if (entryNumber == 0){
						rightValue = BTree.MIN_RIGHT_VALUE;
					}else{
						rightValue = ((LeafNodeEntry)tempEntries[entryNumber-1]).getValue();
					}
					return true;
				}
			}
		}
				
			return false;
	
	}



	public void setEntries(Object[] temp) {
		entries = temp;
		

	}


	public LeafNodeEntry getEntry(Comparable value) {
		if (entryNumber ==0)
		{
			return null;
		}
		
		// look through list and see if we have a match
		
		return indexedBinaryRetrieve(entries, value);
		
		
	
			
			
	}

	public Object[] getEntries() {

		Object[] objArr = new Object[entryNumber];
		System.arraycopy(entries,0,objArr,0,entryNumber);
		return objArr;
		

	}

	public Node splitNode(Object[] tempEntries) throws JoftiException{
			// first insert the entry
	
				Object[] entriesList = split(entries,entryNumber);
				
				Node newNode = NodeFactory.getInstance().createLeafNode();
	
				Comparable currentRight = rightValue;
	
				
				//set up new node
				EntrySplitWrapper newEntries = ((EntrySplitWrapper)entriesList[1]);
				newNode.entryNumber = newEntries.size; 
				newNode.setEntries((Object[])newEntries.entries );
				
				newNode.setRightValue(currentRight);
				newNode.setLinkNode(getLinkNode());
				
	//			replace values in current node
				EntrySplitWrapper replacements = (EntrySplitWrapper)entriesList[0];
				
				
				entries = (Object[])replacements.entries;
				entryNumber = replacements.size;
				setRightValue(((NodeEntry) entries[entryNumber - 1]).getValue());
				
				return newNode;
		}
	
	protected Object[] realGetEntries() {
		
		return entries;
	}

	public boolean contains(Comparable value) {
		if (value != null){
			return rightValue.compareTo(value) >=0;
		}
		return false;
		
	}
	
	public boolean isLeaf(){
		return true;
	}
	
}
