/*
 * NodeEntry.java
 *
 * Created on 25 May 2003, 09:36
 */

package com.jofti.btree;



import java.util.Set;

import com.jofti.util.FastSet;



/**
 * The leaf node entry contains a value, qand a set of uniqueIds that are the ids passed into the node for that value. <br>
 * Adding a new id,value pair will result in the id being added to the set and the value remaining unchanged.<p>
 * 
 *
 * @author Steve Woodcock
 * @version 1.14<br>
 */
public class LeafNodeEntry implements NodeEntry{
    
    
    /**
	 * 
	 */
	private static final long serialVersionUID = -181573341072167495L;

	public  Set uniqueIdSet = null;
    
    public Comparable value = null;
    
    protected volatile int hashCode =0;
    
    /** Creates a new instance of NodeEntry */
    public LeafNodeEntry() {
    }
    
    public LeafNodeEntry(Object uniqueId, Comparable value){
    	uniqueIdSet = new FastSet();
        uniqueIdSet.add(uniqueId);
        this.value =value;
    }
    
    /** Getter for property uniqueIdList.
     * @return Value of property uniqueIdList.
     *
     */
    Set getUniqueIdSet() {
    	if (uniqueIdSet == null){
    		return new FastSet();
    	}
        return uniqueIdSet;
    }
    
    /**
     * Return the size of the Set.
     * @return
     */
    public int getUniqueIdSize(){
    	if (uniqueIdSet == null){
    		return 0;
    	}
    		return uniqueIdSet.size();
    }
    
    /** Setter for property uniqueIdList.
     * @param uniqueIdList New value of property uniqueIdList.
     *
     */
    void setUniqueIdSet(Set uniqueIdList) {
    	if (uniqueIdSet == null){
    		uniqueIdSet = new FastSet();
    	}
        this.uniqueIdSet.clear();
        this.uniqueIdSet.addAll(uniqueIdList);
    }
    
    
    /**
     * Adds an object to the existing Set.
     * @param uniqueId
     */
    public void addUniqueId(Object uniqueId) {
    	if (uniqueIdSet == null){
    		uniqueIdSet = new FastSet();
    	}
        uniqueIdSet.add(uniqueId);
    }
    
     /**
      * Adds the elements of a set to the existing set.
     * @param uniqueIdList
     */
    void addUniqueIdSet(Set uniqueIdList) {
        this.uniqueIdSet.addAll(uniqueIdList);
    }
    
    void removeUniqueId(Object Id) {
    	if (uniqueIdSet == null){
    		return;
    	}
        uniqueIdSet.remove(Id);
    }
    
    void removeAllIds(Set idSet){
    	if (uniqueIdSet == null){
    		return;
    	}
    	uniqueIdSet.removeAll(idSet);
    }
    /** Getter for property value.
     * @return Value of property value.
     *
     */
    public Comparable getValue() {
        return value;
    }
    
    /** Setter for property value.
     * @param value New value of property value.
     *
     */
    
    public void setValue(Comparable value) {
        this.value = value;
    }
    
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("value:"+value);
        buf.append(",");
        buf.append("uniqueIds:" +uniqueIdSet);
        
        return buf.toString();
    }
    
    /** Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.<p>
     *
     * In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of <i>expression</i>
     * is negative, zero or positive.
     *
     * The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)<p>
     *
     * The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.<p>
     *
     * Finally, the implementer must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.<p>
     *
     * It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     *
     * @param   o the Object to be compared.
     * @return  a negative integer, zero, or a positive integer as this object
     * 		is less than, equal to, or greater than the specified object.
     *
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     *
     */
    public int compareTo(Object o) {

        if (o instanceof LeafNodeEntry) 
        {       	
        	return value.compareTo(((LeafNodeEntry)o).value);
        }
        throw new IllegalArgumentException("Cannot compare with a non leafnode");
        
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object o) {

        if (o instanceof LeafNodeEntry) 
        {
            return value.compareTo(((LeafNodeEntry)o).value) == 0;
        } else {
            return false;
        }
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode(){
    	if (hashCode ==0){
    		int result = 17;
    		result = 37*result + value.hashCode();
    		hashCode = result;
    	}
    	return hashCode;
    }

	
}
