/*
 * NodeEntry.java
 *
 * Created on 25 May 2003, 09:36
 */

package com.jofti.btree;


/**
 * 
 * This is a special object in the tree and is used to represent an absolute minimum leaf entry for the whole tree. <br>
 * Class cast issues are taken care of in the Value Object class .<p>
 * 
 * @author Steve Woodcock
 * @version 1.3<br>
 */
final class MinLeafNodeEntry extends LeafNodeEntry {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = -4155706530136083168L;
	private final Comparable value = new ValueObject(Integer.MIN_VALUE,ValueObject.MIN_COMAPARBLE_VALUE);
  
    public MinLeafNodeEntry(){
    	
    }
    
    public Comparable getValue() {
        return value;
    }
    
    /** Setter for property value.
     * @param value New value of property value.
     *
     */
    
    public void setValue(Comparable value) {
        //not supported
    }
    
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("value:"+value);
        buf.append(",");

        
        return buf.toString();
    }
    
    /** Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.<p>
     *
     * In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of <i>expression</i>
     * is negative, zero or positive.
     *
     * The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)<p>
     *
     * The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.<p>
     *
     * Finally, the implementer must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.<p>
     *
     * It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     *
     * @param   o the Object to be compared.
     * @return  a negative integer, zero, or a positive integer as this object
     * 		is less than, equal to, or greater than the specified object.
     *
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     *
     */
    public int compareTo(Object o) {
        if (o instanceof MinLeafNodeEntry) {
            return 0;
        }
        return -1;
    }
    
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
       return false;
    }
    

}
