/*
 * Node.java
 *
 * Created on 09 May 2003, 15:08
 */

package com.jofti.btree;

import com.jofti.oswego.concurrent.FIFOReadWriteLock;
import com.jofti.oswego.concurrent.ReadWriteLock;





/**
 * <p>Base class for Node providing the {@link ReadWriteLock} used in each Node to provide locking semantics.</p>
 * 
 * @author steve Woodcock
 * @version 1.15
 *
 */
abstract public class Node implements INode{
    
	 public final ReadWriteLock nodeLock = new FIFOReadWriteLock();

	 protected int entryNumber = 0;
  
	
    protected Object[] split(Object[] tempEntries, int entryNumber) {
		// first insert the entry
			Object[] entriesList = new Object[2];
						
			// redistribute over old and new node
			
			int splitPoint = (entryNumber / 2);
			
			Object[] newSplitValues = new Object[BTree.getMaxNodeSize()];


			int endPoint = entryNumber - splitPoint;
			// copies the split values into the new array
			System.arraycopy(tempEntries,splitPoint,newSplitValues,0,endPoint);
			
			EntrySplitWrapper splitWrapper = new EntrySplitWrapper();
			splitWrapper.size = endPoint;
			splitWrapper.entries = newSplitValues;
			
			// remove the higher ones
			for(int i=splitPoint;i<entryNumber;i++){
				tempEntries[i]=null;
			}
			
			EntrySplitWrapper replacementWrapper = new EntrySplitWrapper();
			replacementWrapper.size = splitPoint;
			replacementWrapper.entries = tempEntries;
						
			
			
			entriesList[0] =replacementWrapper;
			entriesList[1]=splitWrapper;
			return entriesList;
	
	}

   
    
	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#getNodeLock()
	 */
	public ReadWriteLock getNodeLock()
	{
		return nodeLock;
	}
	
	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#isLeaf()
	 */
	public boolean isLeaf(){
		return false;
	}

}
