/*
 * NodeFactory.java
 *
 * Created on 25 May 2003, 12:21
 */

package com.jofti.btree;


import com.jofti.core.IStoreKey;
import com.jofti.core.IStoreManager;


/**
 * This factory is responsible for generating new Leaf and IndexCache Nodes for the Tree.<p>
 * 
  * @author Steve Woodcock
 * @version 1.15<br>
 */
class NodeFactory {
    
    private static NodeFactory factory = null;
    IStoreManager manager =null;

   /** Creates a new instance of NodeFactory */
    private NodeFactory() {
    }
    
   private NodeFactory(IStoreManager manager){
   	this.manager = manager;
   }
    
    /**
     * Obtains the NodeFactory Singleton instance.Creates the factory if it does not exist.
     * @return
     */
    static synchronized NodeFactory getInstance() {
    	if (factory == null){
	    	factory = new NodeFactory();
	        
    	}
    	return factory;
    }
    
    /**
     * Obtains the NodeFactory Singleton instance. Creates the factory if it does not exist with the 
     * passed in {@link IStoreManager}.
     * 
     * @param manager
     * @return
     */
    static synchronized NodeFactory getInstance(IStoreManager manager) {
    	if (factory == null){
	    	factory = new NodeFactory(manager);
	        
    	}
    	return factory;
    }
    
    IndexNode createIndexNode() {
        return new IndexNode();
    }
    
    Node createLeafNode() {
    	Node temp =null;
    	if (manager != null){
    		try {
    			IStoreKey storeKey = manager.getNextKey();
    			temp = new PagedLeafNode(manager,storeKey);
    		} catch (Exception e){
    			throw new RuntimeException("unable to get node ",e);
    		}
    		
    		
    	}else{
    		temp = new LeafNode();
    	}
    		
    return temp;
    }
   
    
    IndexNodeEntry createIndexNodeEntry() {
        return new IndexNodeEntry();
    }
    
    LeafNodeEntry createLeafNodeEntry() {
        return new LeafNodeEntry();
    }
    
    LeafNodeEntry createMaxLeafNodeEntry() {
       
            return new MaxLeafNodeEntry();
       
    }
    
    LeafNodeEntry createLeafNodeEntry(Object uniqueId, Comparable value) {     
            return new LeafNodeEntry(uniqueId,value);
    }

}
