/*
 * Created on 07-Oct-2004
 *
 */
package com.jofti.btree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.jofti.exception.JoftiException;
import com.jofti.oswego.concurrent.ReadWriteLock;



/**
 * The implementation class for the IResultNode. 
 * 
 * @author Steve Woodcock
 * @version 1.0<br>
 */
public class ResultNode  implements INode,IResultNode{

	private Object[] entries =null;
	private Comparable rightValue;
	private int entryNumber;
	boolean isDeleted;
	NodeLink link;
	private INode node;
	
	ResultNode (INode node){
		entries = node.getEntries();
		if (entries == null){
			throw new RuntimeException("entries are null for "+node.getRightValue());
	}
		
		entryNumber = node.getEntryNumber();
		rightValue = node.getRightValue();
		isDeleted = node.isDeleted();
		link = node.getLinkNode();
		this.node =node;
	}
	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#getRightValue()
	 */
	public Comparable getRightValue()
	{
		return rightValue;
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#setRightValue(java.lang.Comparable)
	 */
	public void setRightValue(Comparable value)
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 
		
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#contains(java.lang.Comparable)
	 */
	public boolean contains(Comparable value)
	{
		if (value == null)
		{
			return false;
		}
		
		return rightValue.compareTo(value) >=0;
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#insertEntry(com.jofti.btree.NodeEntry)
	 */
	public Object[] insertEntry(NodeEntry entry) throws JoftiException
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 

	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#deleteEntry(com.jofti.btree.NodeEntry)
	 */
	public boolean deleteEntry(NodeEntry entry)
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 

	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#split()
	 */
	public List split()
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 

	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#splitNode()
	 */
	public Node splitNode(Object[] temp)
	{
		
		throw new UnsupportedOperationException("Modification of node not supported"); 

	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#getEntryNumber()
	 */
	public int getEntryNumber()
	{
		
		return entryNumber;
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#isUnderFull()
	 */
	public boolean isUnderFull()
	{
		
		throw new UnsupportedOperationException("Modification of node not supported"); 

	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#isEmpty()
	 */
	public boolean isEmpty()
	{
		
		return entryNumber == 0;
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#isDeleted()
	 */
	public boolean isDeleted()
	{
		
		return isDeleted;
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#setDeleted(boolean)
	 */
	public void setDeleted(boolean deleted)
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 

		
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#getEntries()
	 */
	public Object[] getEntries()
	{
		
		return entries; 

	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#setEntries(java.util.List)
	 */
	public void setEntries(List entries)
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 

		
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#getLinkNode()
	 */
	public NodeLink getLinkNode()
	{
		
		return new ResultNodeLink(link); 
	}

	public IResultNode getNextNode(){
		return new ResultNode(link.getNode());
	}
	/* (non-Javadoc)
	 * @see com.jofti.btree.Node#setLinkNode(com.jofti.btree.NodeLink)
	 */
	public void setLinkNode(NodeLink node)
	{
		throw new UnsupportedOperationException("Modification of node not supported"); 

		
	}
	/* (non-Javadoc)
	 * @see com.jofti.btree.INode#getNodeLock()
	 */
	public ReadWriteLock getNodeLock()
	{
		
		throw new UnsupportedOperationException("Modification of node not supported"); 

	}
	/* (non-Javadoc)
	 * @see com.jofti.btree.IResultNode#getEntry(java.lang.Comparable)
	 */
	public LeafNodeEntry getEntry(Comparable value)
	{

		if (entries.length ==0)
		{
			return null;
		}
		// look through list and see if we have a match
		
		return  indexedBinaryRetrieve(entries, value);
		
		
	}

	INode getDelegate(){
		return node;
	}

	 protected  int indexedBinarySearch(Object[] arr1, Object obj)
	    {
		 int low = 0;
			int high = entryNumber-1;
			
			LeafNodeEntry entry =null;
			while (low <= high) {
			    int mid = (low + high) >> 1;
			    
			    entry = (LeafNodeEntry)arr1[mid];
	            int cmp = entry.getValue().compareTo(obj);

			    if (cmp < 0)
				low = mid + 1;
			    else if (cmp > 0)
				high = mid - 1;
			    else
				return mid; // key found
			}
			return -(low + 1);  // key not found
	    }
	
	 
	 protected LeafNodeEntry indexedBinaryRetrieve(Object[] list1,  Object obj) {
			int i = 0;
	        int size = entryNumber;
			for (int j =  size- 1; i <= j;) {
				int k = i + j >> 1;
				LeafNodeEntry obj1 = (LeafNodeEntry)list1[k];
				int l =  obj1.getValue().compareTo(obj);
				if (l < 0)
					i = k + 1;
				else if (l > 0)
					j = k - 1;
				else
					return obj1;
			}

			return null;
		}
	 
	public int hashCode(){
		return node.hashCode();
	}

	/* (non-Javadoc)
	 * @see com.jofti.btree.IResultNode#getEntriesBefore(java.lang.Comparable)
	 */
	public Collection getEntriesBefore(Comparable value)
	{

	
		return null;
	}
	
	
	 

	 public boolean equals(Object obj){
	 	if (obj instanceof IResultNode){
	 		return getDelegate() == ((ResultNode)obj).getDelegate();
	 	}
	 	return false;
	 }
	public void setEntries(Object[] entries) {
		throw new UnsupportedOperationException("Modification of node not supported"); 
		
	}
	
	public boolean isLeaf(){
		return true;
	}
}
