/*
 * ValueObject.java
 *
 * Created on 02 June 2003, 20:59
 */

package com.jofti.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;



/**
 *
 * This is used to wrap all values put into the Tree. It is is responsible for the comparison ordering for dimensions 
 * and for checking the values against the min and max values int he tree and the dimension.
 *
 * @author Steve Woodcock
 * @version 1.0<br>
 */
public class ValueObject implements Comparable, Externalizable {
    
	/**
	 * 
	 */
	public static final Comparable MIN_COMAPARBLE_VALUE = new MinComparableValue();
	public static final Comparable MAX_COMAPARBLE_VALUE = new MaxComparableValue();

    int dimension =0;
 
    
    Comparable realValue = null;
    volatile int hashCode =0;
    
    
    public ValueObject() {
    }
    /** Creates a new instance of ValueObject */
    public ValueObject(int dimension, Comparable value) {
        this.dimension = dimension;
        this.realValue = value;
    }
    
    public ValueObject(Comparable value) {
        this.realValue = value;
    }
    
    public int compareTo(Object o) {
    	
    	//comparison by identity
    
    	
    	ValueObject obj = (ValueObject)o;
    	
    	
    	
         if (dimension == obj.dimension) {             
                // none are special values
                if ( realValue != MAX_COMAPARBLE_VALUE && obj.realValue != MAX_COMAPARBLE_VALUE
                        && realValue != MIN_COMAPARBLE_VALUE  && obj.realValue != MIN_COMAPARBLE_VALUE){
                    return realValue.compareTo(obj.realValue);
                    // if either is special value to result in this obj being bigger 
                } else if ( (realValue == MAX_COMAPARBLE_VALUE && obj.realValue != MAX_COMAPARBLE_VALUE)
                        || (realValue != MIN_COMAPARBLE_VALUE ) && obj.realValue== MIN_COMAPARBLE_VALUE ){
                    return 1;
                    // if either is special value to result in this obj being smaller
                }else if ( (realValue != MAX_COMAPARBLE_VALUE && obj.realValue == MAX_COMAPARBLE_VALUE)
                        || (realValue == MIN_COMAPARBLE_VALUE ) && obj.realValue!= MIN_COMAPARBLE_VALUE ){
                        return -1;
                        // otherwise equla for special values
                }else{
                    return 0;
                    
                } 

	        }   else if (dimension > obj.dimension) {
	        	return 1;
	        } else {
	        	return -1;
	        }
    	
    }
    
    
    public boolean equals(Object o){
    	
    		return (compareTo(o)==0);
    	
    }
    
    public int hashCode (){
    	if (hashCode == 0){
    		int temp =17;
    		temp = temp*37 +dimension;
    		temp= temp*37 + realValue.hashCode();
    		hashCode = temp;
    	}
    	return hashCode;
    }
    /** Getter for property dimension.
     * @return Value of property dimension.
     *
     */
    public int getDimension() {
        return dimension;
    }
    
    
    /** Getter for property realValue.
     * @return Value of property realValue.
     *
     */
    public java.lang.Object getRealValue() {
        return realValue;
    }
    
    public String toString(){
        StringBuffer buf = new StringBuffer();
        buf.append("dimension:" + dimension);
        buf.append(", real Value:" + realValue);
        return buf.toString();
    }

	public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		dimension = in.readInt();
		realValue = (Comparable)in.readObject();
		
	}

	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(dimension);
		out.writeObject(realValue);
		
	}
   

 
}
