/*
 * Created on 08-Apr-2005
 *
 */
package com.jofti.cache;

import java.util.Properties;

import com.jofti.core.InternalIndex;
import com.jofti.exception.JoftiException;

/**
 
 * 
 * Lifecycle events to enable the indexManager to manage caches.<p>
 *
 ** @author Steve Woodcock (steve@jofti.com)<p>
 */
public interface LifeCycleAdapter {

	
	/**
	 * Returns the name of the adapter. 
	 * @return - the adpater name.
	 */
	public String getName();
	
	
	/**
	 * Sets a name into the adpater. The name is used to uniquely identify an Index in the index manager and 
	 * is used to obtain the named Cache from the Cache implementation.
	 * @param name
	 */
	public void setName(String name);
	
	/**
	 * Initialises the adapter. This is called as part of the IndexManager's initialisation as it instantiates each of the 
	 * configured Caches, or when an Index is added to the manager. The adpater is responsible for initialising the Cache (if 
	 * necessary) and the Index for that Cache instance. <p>
	 * This method will always be called on a new adapter.</p>
	 * 
	 * @param properties The initialisation properties to start the Adapter.
	 * @throws JoftiException
	 */
	public void init(Properties properties) throws JoftiException;
	
	/**
	 * Called after the initialisation method by the IndexManager on a new Adapter (either configured or added). The adapter can 
	 * provide an empty initialisation if required. Typically this method is used to Index all the exisiting (if any) entries in an existing Cache 
	 * when an Adapter is added to the Manager.</p>
	 * @throws JoftiException
	 */
	public void start() throws JoftiException;
	
	
	 /**
	  * Called by the IndexManager to destroy a Cache. This should not be called directly on the Index as it does not remove the 
	  * Index from the set of registered Indexes in the manager. </p>
	  * The method should result in the Index removing all values it has indexed for a Cache and aslo attempt to destro (or shutdown) 
	  * the Cache implementation. </p>
	  * Once called the Index instance is noi longer useable.
	 * @throws JoftiException
	 */
	public void destroy() throws JoftiException;
	 
	
	 /**
	  * Sets the real Index into the adapter.
	 * @param index
	 */
	public void setInternalIndex(InternalIndex index);
	 
}
