/*
 * Created on 10-Jul-2005
 *
 */
package com.jofti.cache;

import java.io.Serializable;

/**

 *
 *The implmentation class for keys that do not implement Comparable.<p>
 *
  * @author Steve Woodcock (steve@jofti.com)<p>
 */
public class NonComparableKeyWrapper implements INonComparableKeyWrapper, Serializable {

	
	

	private static final long serialVersionUID = 7309788376554006517L;
	
	private Object key;
	
	public NonComparableKeyWrapper(Object key){
		this.key = key;
	}
	
	public Object getKey() {
		return key;
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
	
		if (o instanceof INonComparableKeyWrapper){
			return key.toString().compareTo(((INonComparableKeyWrapper)o).getKey().toString());
		}else{
			return -1;
		}
	}
	
	public boolean equals(Object o){
		if (o instanceof INonComparableKeyWrapper){
			return key.equals(((INonComparableKeyWrapper)o).getKey());
		}else{
			return false;
		}
	}

	public int hashCode(){
		return key.hashCode();
	}
	
	public String toString(){
		return key.toString();
	}
}
