/*
 * Created on 01-Sep-2005
 *
 */
package com.jofti.cache;

import com.jofti.oswego.concurrent.Sync;




/**
 
 * This is an adaptation of Doug Lea's ReaderWriter lock to allow effectively two groups of readers. 
 * Any number of readers in one of the groups can be share one lock, but only one group of readers 
 * can be active at once. The difference is that the writer lock (which was a single entry) now behaves like a read lock
 * but without the single access restriction.
 * 
 * @author xenephon (xenephon@jofti.com)
 *
 */
public class QueryUpdateLock {

	  protected class WriterLock extends Signaller
      implements Sync
  {

      public void acquire()
          throws InterruptedException
      {
          if(Thread.interrupted())
              throw new InterruptedException();
          InterruptedException interruptedexception = null;
          synchronized(this)
          {
              if(!startWriteFromNewWriter())
                  try
                  {
                      do
                          wait();
                      while(!startWriteFromWaitingWriter());
                      return;
                  }
                  catch(InterruptedException interruptedexception1)
                  {
                      cancelledWaitingWriter();
                      interruptedexception = interruptedexception1;
                  }
          }
          if(interruptedexception != null)
          {
              readerLock_.signalWaiters();
              throw interruptedexception;
          } else
          {
              return;
          }
      }

      public void release()
      {
          Signaller signaller = endWrite();
          if(signaller != null)
              signaller.signalWaiters();
      }

      synchronized void signalWaiters()
      {
          notify();
      }

      public boolean attempt(long l)
          throws InterruptedException
      {
          if(Thread.interrupted())
              throw new InterruptedException();
          InterruptedException interruptedexception = null;
          synchronized(this)
          {
              if(l <= 0L)
              {
                  boolean flag = startWrite();
                  return flag;
              }
              if(startWriteFromNewWriter())
              {
                  boolean flag1 = true;
                  return flag1;
              }
              long l1 = l;
              long l2 = System.currentTimeMillis();
              do
              {
                  try
                  {
                      wait(l1);
                  }
                  catch(InterruptedException interruptedexception1)
                  {
                      cancelledWaitingWriter();
                      notify();
                      interruptedexception = interruptedexception1;
                      break;
                  }
                  if(startWriteFromWaitingWriter())
                  {
                      boolean flag2 = true;
                      return flag2;
                  }
                  l1 = l - (System.currentTimeMillis() - l2);
                  if(l1 > 0L)
                      continue;
                  cancelledWaitingWriter();
                  notify();
                  break;
              } while(true);
          }
          readerLock_.signalWaiters();
          if(interruptedexception != null)
              throw interruptedexception;
          else
              return false;
      }

      protected WriterLock()
      {
      }
  }

  protected class ReaderLock extends Signaller
      implements Sync
  {

      public void acquire()
          throws InterruptedException
      {
          if(Thread.interrupted())
              throw new InterruptedException();
          InterruptedException interruptedexception = null;
          synchronized(this)
          {
              if(!startReadFromNewReader())
                  try
                  {
                      do
                          wait();
                      while(!startReadFromWaitingReader());
                      return;
                  }
                  catch(InterruptedException interruptedexception1)
                  {
                      cancelledWaitingReader();
                      interruptedexception = interruptedexception1;
                  }
          }
          if(interruptedexception != null)
          {
              writerLock_.signalWaiters();
              throw interruptedexception;
          } else
          {
              return;
          }
      }

      public void release()
      {
          Signaller signaller = endRead();
          if(signaller != null)
              signaller.signalWaiters();
      }

      synchronized void signalWaiters()
      {
          notifyAll();
      }

      public boolean attempt(long l)
          throws InterruptedException
      {
          if(Thread.interrupted())
              throw new InterruptedException();
          InterruptedException interruptedexception = null;
          synchronized(this)
          {
              if(l <= 0L)
              {
                  boolean flag = startRead();
                  return flag;
              }
              if(startReadFromNewReader())
              {
                  boolean flag1 = true;
                  return flag1;
              }
              long l1 = l;
              long l2 = System.currentTimeMillis();
              do
              {
                  try
                  {
                      wait(l1);
                  }
                  catch(InterruptedException interruptedexception1)
                  {
                      cancelledWaitingReader();
                      interruptedexception = interruptedexception1;
                      break;
                  }
                  if(startReadFromWaitingReader())
                  {
                      boolean flag2 = true;
                      return flag2;
                  }
                  l1 = l - (System.currentTimeMillis() - l2);
                  if(l1 > 0L)
                      continue;
                  cancelledWaitingReader();
                  break;
              } while(true);
          }
          writerLock_.signalWaiters();
          if(interruptedexception != null)
              throw interruptedexception;
          else
              return false;
      }

      protected ReaderLock()
      {
      }
  }

  protected abstract class Signaller
  {

      abstract void signalWaiters();

      protected Signaller()
      {
      }
  }


  public QueryUpdateLock()
  {
      activeReaders_ = 0L;
      activeWriters_ = 0l;
      waitingReaders_ = 0L;
      waitingWriters_ = 0L;
  }

  public Sync queryLock()
  {
      return writerLock_;
  }

  public Sync updateLock()
  {
      return readerLock_;
  }

  protected synchronized void cancelledWaitingReader()
  {
      waitingReaders_--;
  }

  protected synchronized void cancelledWaitingWriter()
  {
      waitingWriters_--;
  }

  protected boolean allowReader()
  {
      return activeWriters_ <=0l  ;
  }
  
  protected boolean allowWriters()
  {
      return  activeReaders_ <=0l ;
  }


  protected synchronized boolean startRead()
  {
      boolean flag = allowReader();
      if(flag){

          activeReaders_++;
      }
      return flag;
  }

  protected synchronized boolean startWrite()
  {
  	 boolean flag = allowWriters();
     if(flag){

     	 
         activeWriters_++;
     }
     return flag;
  }

  protected synchronized boolean startReadFromNewReader()
  {
      boolean flag = startRead();
      if(!flag){
          waitingReaders_++;
      }
      
      return flag;
  }

  protected synchronized boolean startWriteFromNewWriter()
  {
      boolean flag = startWrite();
      if(!flag)
          waitingWriters_++;
      return flag;
  }

  protected synchronized boolean startReadFromWaitingReader()
  {
      boolean flag = startRead();
      if(flag)
    		  waitingReaders_--;
         
      return flag;
  }

  protected synchronized boolean startWriteFromWaitingWriter()
  {
      boolean flag = startWrite();
      if(flag){
          waitingWriters_--;
      }
      return flag;
  }

  protected synchronized Signaller endRead()
  {
  	 --activeReaders_;
  	
  	
// these are the changes so the readers and writers form two groups
     if(waitingWriters_ > 0L){

         return writerLock_;
     }
     if(waitingReaders_ > 0L){

         return readerLock_;
     }
     else
         return null;
  }

  protected synchronized Signaller endWrite()
  {
      --activeWriters_;

      if(waitingReaders_ > 0L )
      {
          return readerLock_;
      }
      if(waitingWriters_ > 0L){
         return writerLock_;
     }
      else
          return null;
  }

  protected long activeReaders_;
  protected long activeWriters_;
  protected long waitingReaders_;
  protected long waitingWriters_;
  protected final ReaderLock readerLock_ = new ReaderLock();
  protected final WriterLock writerLock_ = new WriterLock();
}
