package com.jofti.cache.adapter;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.api.CacheAccessor;
import com.jofti.api.IndexQuery;
import com.jofti.cache.CacheListenerAdapter;
import com.jofti.cache.BaseAdaptor;
import com.jofti.cache.adapter.listener.EhEventListener;
import com.jofti.core.INameSpaceAware;
import com.jofti.core.IParsedQuery;
import com.jofti.core.InternalIndex;
import com.jofti.core.QueryId;
import com.jofti.core.QueryType;
import com.jofti.exception.JoftiException;
import com.jofti.util.CompositeComparator;

/**

 * 
 * The adapter implementation specific to EHCache.</p>
 * 
 * The adapter takes care of the implementation specific details for converting
 * between the process the index expects and the behaviour of EHCache.</p>
 * 
 * The Listener adapter is for use as a listener to EHCache and does not provide the get, set, remove methods 
 * that the wrapper adapter provides. The addition, removal and getting of values from the Cache must be 
 * done on the Cache implementation directly. This is the preferred way of using an already existing Cache.</p>
 * 
 * The start up of the adapter will also try and index any elements already in
 * the cache.<P>
 * 
 * @author Steve Woodcock
 *         <p>
 * @version 1.0
 * @since 1.1
 */
public class EhCacheListenerAdapter extends BaseAdaptor implements CacheAccessor, CacheListenerAdapter
{


    private static Log                  log = LogFactory
                                                    .getLog(EhCacheListenerAdapter.class);


    private String                      name;


    private EhEventListener eventListener = null;
    
    private net.sf.ehcache.Cache        cache;
    


    public EhCacheListenerAdapter()
    {
    }

    public EhCacheListenerAdapter(Object cache)
    {
        this.cache = (net.sf.ehcache.Cache) cache;

    }
    /* (non-Javadoc)
     * @see com.jofti.cache.LifeCycleAdapter#init(java.util.Properties)
     */
    public synchronized void init(Properties properties) throws JoftiException
    {
        if (properties != null) {
            String key = null;
            for (Iterator it = properties.keySet().iterator(); it.hasNext();) {
                key = (String) it.next();
                if (MUTABLE_VALUES.equalsIgnoreCase(key)) {
                    checkMutable = Boolean.valueOf(
                            properties.getProperty(key)).booleanValue();
                    if (log.isInfoEnabled()) {
                        log.info("Mutability checking is set to "
                                + checkMutable);
                    }
                }
                if ("file".equalsIgnoreCase(key)) {
                    log.warn("Listener adapters cannot be used to start up a Cache - check docs for Adapter Type");
                    throw new JoftiException("Listener adapters cannot be used to start up a Cache -  check docs for Adapter Type");
                }
            }
        }

     
        if (cache == null) {
            throw new JoftiException("Cache cannot be null for listener adapter");
        } else {
        	log.info("Index started using cache "+ cache.getName());
        }
        eventListener = new EhEventListener(this);
    
    }

    
 
   

    /* (non-Javadoc)
     * @see com.jofti.cache.LifeCycleAdapter#destroy()
     */
    public synchronized void destroy() throws JoftiException
    {
        try {
           if (index != null){
                index.removeAll();
           }
        } catch (IllegalStateException e) {
            throw new JoftiException(e);
        }
    }

    /* (non-Javadoc)
     * @see com.jofti.cache.LifeCycleAdapter#getName()
     */
    public String getName()
    {
        return name;
    }

    /* (non-Javadoc)
     * @see com.jofti.cache.LifeCycleAdapter#setName(java.lang.String)
     */
    public void setName(String name)
    {
        this.name = name;
    }

    public String toString()
    {
        return "EHCache(" + getName() + ')';
    }

  


    /*
     * (non-Javadoc)
     * 
     * @see com.jofticache.CacheAdapter#setInternalIndex(com.jofti.core.InternalIndex)
     */
    public void setInternalIndex(InternalIndex index)
    {
        this.index = index;

    }

   

	/**
	 * @param cache
	 */
	public void setCacheImpl(Object cache){
		EhCacheListenerAdapter.this.cache = (Cache)cache;
		if (cache != null){
			((Cache)cache).getCacheEventNotificationService().registerListener(eventListener);
		}
		
	}
	
  	protected Object getCacheValue(Object key) {
		try {
			return cache.get((Serializable) key).getValue();
		} catch (CacheException e) {
			log.warn(e);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see com.jofti.cache.LifeCycleAdapter#start()
	 */
	public void start() throws JoftiException {
		if (cache != null){
			((Cache)cache).getCacheEventNotificationService().registerListener(eventListener);
			  try {
	            loadInitialValues(cache);
	        } catch (CacheException ce) {
	            throw new JoftiException(ce);
	        }
		}
		
		
	}

	  private void loadInitialValues(net.sf.ehcache.Cache cache)
			throws CacheException, JoftiException {
		List keys = cache.getKeys();
		 int size = keys.size();
	        Iterator it = keys.iterator();
	    for (int i=0;i<size;i++) {
		
			Object key = it.next();
			Element element = cache.get((Serializable) key);
			// then we must remove from index
			eventListener.notifyElementPut(cache, element);

		}
	}


	/* (non-Javadoc)
	 * @see com.jofti.cache.CacheLocking#getIndex()
	 */
	public InternalIndex getIndex() {
		
		return index;
	}

	/* (non-Javadoc)
	 * @see com.jofti.api.CacheAccessor#getCacheImpl()
	 */
	public Object getCacheImpl() {
		
		return cache;
	}

	public IndexQuery addQuery(String name, IndexQuery query)throws JoftiException {
		
		return index.getParserManager().addQuery(name, query);
	}

	/* (non-Javadoc)
	 * @see com.jofti.api.Index#getQuery(java.lang.String)
	 */
	public IndexQuery getQuery(String name)  {
		
		return index.getParserManager().getQuery(name);
	}
	
}