/*
 * Created on 12-May-2005
 *
 */
package com.jofti.cache.adapter;

import java.util.Map;

import com.jofti.api.IndexCache;
import com.jofti.api.IndexQuery;
import com.jofti.api.NameSpaceKey;
import com.jofti.exception.JoftiException;

/**
 * 
 *
 * The interface provides common operations for the local indexer used in 
 * the JBossCacheAdapter to isolate changes within transactions.<p>
 * 
 * @author Steve Woodcock
 */
public interface JBossIndexer {

	/**
     * Registers the fact that a value has been updated within a transacton.
	 * @param keyWrapper
	 * @param oldValue
	 * @param newValue
	 * @throws JoftiException
	 */
	public void update(NameSpaceKey keyWrapper, Object oldValue, Object newValue) throws JoftiException;
	
	/**
     * Registers that a new value has been added within a transaction.
	 * @param keyWrapper
	 * @param value
	 * @throws JoftiException
	 */
	public void add(NameSpaceKey keyWrapper, Object value)throws JoftiException;
	
	/**
     * Registers a remocal of a value within a transaction.
	 * @param keyWrapper
	 * @param value
	 * @throws JoftiException
	 */
	public void remove(NameSpaceKey keyWrapper, Object value)throws JoftiException;
	
	
	/**
     * Registers a key removal. This will also remove the values the index knows about, although 
     * the caller does not know what the values were.<p> 
	 * @param keyWrapper
	 * @throws JoftiException
	 */
	public void remove(NameSpaceKey keyWrapper)throws JoftiException;
	
	/**
     * Used to check if the IndexCache contains the key.<p>
	 * @param keyWrapper
	 * @return a boolean indicating if the value exists in the index
	 * @throws JoftiException
	 */
	public boolean contains(NameSpaceKey keyWrapper)throws JoftiException;
	
       /**
     * This queries the index and retrieves a map of matching elements (if any). The map contains 
     * key/value pairs and the result is ordered by the attribute being searched on (if a single attribute is used in the query).
     * The ordering is preserved in the iteration as it is a @link {java.util.LinkedHashMap}.
     * <p>
     * @param query - the type of query to perform against the index and cache.
     * <p>
     * @return Map a map of the results of type @link {NameSpaceKey}
     * @throws JoftiException a wrapper exception for errors in the query. <br>
     */
	public Map query(IndexQuery query,IndexCache cache) throws JoftiException;
	
	
}
