/*
 * Created on 11-May-2005
 *
 */
package com.jofti.cache.adapter;


import com.jofti.api.NameSpaceKey;

/**
 *
 *
 *Used in the JBossCacheAdapter index. The wrapper provides comparableness and ordering for 
 *the JBoss Fqn key. Specifically, the namespace object is checked first. If they are of the same type and equal then the key is checked. 
 * Otherwise if both objects are of the same type and comparable then natual ordering occurs on these objects. However, if they are not the same type 
 * then ordering of the toString() method is taken (while this may not provide consistency 
 * across time, we do not care as this is reasonable to provide key ordering in the index - which is not visible to the caller).
 * <p>
 * Key Comparison is done in a similar manner.<p>
 * 
 *  @author Steve Woodcock
 */
public class NameSpaceKeyWrapper implements Comparable, NameSpaceKey {

	
	
	/**
	 * @return Returns the key.
	 */
	public Object getKey() {
		return key;
	}

	private static String KEY_DEFAULT = "KEY";
	
	protected Object nameSpace = null;
	
	protected Class nameSpaceClass;
	
	protected Object key =null;
	protected Class keyClass = null;
	int hashCode =0;
	
	private String nameSpaceCompareString = null;
	
	/**
     * Constructs a wrapper for a namespace and key object. Null keys are given the String 
     * value "KEY".
	 * @param nameSpace
	 * @param key
	 */
	public NameSpaceKeyWrapper(Object nameSpace, Object key){
		this.nameSpace = nameSpace;
		nameSpaceClass = this.nameSpace.getClass();
		if (key != null){
			this.key = key;
			keyClass = key.getClass();
		} else{
			key = KEY_DEFAULT;
			keyClass = this.key.getClass();
		}
		this.nameSpaceCompareString = nameSpace.toString() + "."+key;
		hashCode =nameSpace.hashCode() + key.hashCode();
	}
	
	public NameSpaceKeyWrapper(Object nameSpace){
		this(nameSpace, KEY_DEFAULT);
	}
	
	
	public int compareTo(Object o) {
		
		
		try{
			
			NameSpaceKeyWrapper temp = (NameSpaceKeyWrapper)o;

			
			// if the namespaces are the same type & comparable
			if (nameSpaceClass.equals(temp.nameSpaceClass) 
					&& nameSpace.equals(temp.nameSpace))
			{
				// the name spaces are equal
					// compare the keys if they are comparable
					if (keyClass.equals(temp.keyClass) 
							&& key instanceof Comparable){
						return ((Comparable)key).compareTo(temp.key);
					}
					// otherwise we have mismatched key types - so devolve to String
					return key.toString().compareTo(temp.key.toString());

			}else{
				// do a compare to on String
				if (nameSpaceClass.equals(temp.nameSpaceClass) 
						&& nameSpace instanceof Comparable)
				{
					return ((Comparable)nameSpace).compareTo((Comparable)temp.nameSpace);
				}else{
					return nameSpace.toString().compareTo(temp.nameSpace.toString());
				}
				
			}
		} catch (Throwable t){
			
		}
			return -1;
	}
	
	
	
	public boolean equals(Object o){
		try {
			NameSpaceKeyWrapper temp = (NameSpaceKeyWrapper)o;
			// see if name spaces equal
			if (nameSpaceClass.equals(temp.nameSpaceClass)){
				// name spaces are equal
				if (nameSpace.equals(temp.nameSpace)){
					// see if keys are equals
					if (keyClass.equals(temp.keyClass)){
						return key.equals(temp.key);
					}
				}
			}	
		} catch (Exception e){
			
		}
		return false;
	}
	
	public int hashCode(){
		return hashCode;
	}
	
	public String toString(){
		return nameSpaceCompareString;
	}
	/* (non-Javadoc)
	 * @see com.jofti.core.NameSpaceKey#getNameSpace()
	 */
	public Object getNameSpace() {
		// TODO Auto-generated method stub
		return nameSpace;
	}
	
	protected void setNameSpace(Object nameSpace){
		this.nameSpace = nameSpace;
		this.nameSpaceClass = nameSpace.getClass();
		this.nameSpaceCompareString = nameSpace.toString() + "."+key;
	}
}
