/*
 * Created on 11-May-2005
 */
package com.jofti.cache.adapter;

import com.jofti.core.INameSpace;


/**
 * Provides a unified mechanism for dealing with different namspace objects in 
 * the JBossCacheAdapter.
 * 
 * @author Steve Woodcock
 *
 */
public class NameSpaceWrapper implements Comparable, INameSpace{

	

	
	protected Object nameSpace =null;
	protected Class nameSpaceClass =null;
	int hashCode =0;
	
	public NameSpaceWrapper(Object nameSpace){
		this.nameSpace = nameSpace;
		nameSpaceClass = nameSpace.getClass();
		this.hashCode = nameSpace.hashCode();
		
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		
		if (o != null && o instanceof NameSpaceWrapper){
			NameSpaceWrapper temp = (NameSpaceWrapper)o;
			
			if (nameSpaceClass.equals(temp.nameSpaceClass) 
					&& nameSpace instanceof Comparable)
			{
				return ((Comparable)nameSpace).compareTo((Comparable)temp.nameSpace);
			}else{
				return nameSpace.toString().compareTo(temp.nameSpace.toString());
			}
		} 
		throw new IllegalArgumentException("variable " +o +" is not a NameSpaceWrapper or is null");
		
			
	}
	
	
	
	
	public boolean equals(Object o){
		
		if (o != null && nameSpaceClass.equals(((NameSpaceWrapper)o).nameSpaceClass)) {
			return nameSpace.equals(((NameSpaceWrapper)o).nameSpace);
			
		}else{
			return false;
		}
	}
	
	public int hashCode(){
		return hashCode;
	}
	
	public String toString(){
		return nameSpace.toString();
	}



	/* (non-Javadoc)
	 * @see com.jofti.core.INameSpace#getDelegate()
	 */
	public Object getDelegate() {
		return nameSpace;
	}
}
