/*
 * Created on 30-Oct-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.cache.adapter.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.cache.IBaseAdaptor;
import com.jofti.core.InternalIndex;
import com.jofti.exception.JoftiException;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;

/**
 * The Class used to provide the connection between the adapter and the Cache for Listener adapters. </p>
 * The Listener is for Coherence 3.x and above. </p>
 * @author xenephon
 * @version 1.4
 * @since 1.2
 *
 */
public class CoherenceEventListener implements MapListener{

	
	IBaseAdaptor base = null;
	
    private static Log                  log = LogFactory
    .getLog(CoherenceEventListener.class);
    
	/**
	 * 
	 */
	public CoherenceEventListener(IBaseAdaptor base) {
		this.base = base;
	}

	/* (non-Javadoc)
	 * @see com.tangosol.util.MapListener#entryInserted(com.tangosol.util.MapEvent)
	 */
	public void entryInserted(MapEvent arg0) {
		Object key = arg0.getKey();
		Object value = arg0.getNewValue();
		key = base.decorateKey(key);
		try {
			base.acquireUpdateLock();
			try {
				InternalIndex index = base.getIndex();
				synchronized(base.getCacheLock(key))
				{			
					// insert into the index
					index.insert(key,value);
				}
				if (log.isDebugEnabled()){
					log.debug("Add Event: entry added to index "+key + " value: "+ value);
				}
			} catch (JoftiException e){
				log.error("Add Event: Unable to add index value for key "+key,e);
				// should we remove the value if we cannot add it?
			}finally {
				base.releaseUpdateLock();
			}
			
			
		} catch (Exception e){
			log.error(e);
		}
	
		
		
	}

	/* (non-Javadoc)
	 * @see com.tangosol.util.MapListener#entryUpdated(com.tangosol.util.MapEvent)
	 */
	public void entryUpdated(MapEvent arg0) {
		Object key = arg0.getKey();
		Object value = arg0.getNewValue();
		
		key = base.decorateKey(key);
		
		try {
			base.acquireUpdateLock();
			try {
				InternalIndex index = base.getIndex();
				synchronized(base.getCacheLock(key))
				{			
					//remove the original value
					index.removeByKey(key);
					// insert into the index
					index.insert(key,value);
				}
				if (log.isDebugEnabled()){
					log.debug("Update Event: entry added to index "+key + " value: "+ value);
				}
			} catch (JoftiException e){
				log.error("Update Event: Unable to add index value for key "+key,e);
				// should we remove the value if we cannot add it?
			}finally {
				base.releaseUpdateLock();
			}
			
			
		} catch (Exception e){
			log.error(e);
		}
		
		
		
	}

	/* (non-Javadoc)
	 * @see com.tangosol.util.MapListener#entryDeleted(com.tangosol.util.MapEvent)
	 */
	public void entryDeleted(MapEvent arg0) {
		Object key = arg0.getKey();
		key = base.decorateKey(key);
		

		try {
			base.acquireUpdateLock();
			try {
				InternalIndex index = base.getIndex();
				synchronized(base.getCacheLock(key))
				{			
					// insert into the index
					index.removeByKey(key);
				}
				if (log.isDebugEnabled()){
					log.debug("Remove Event: entry added to index "+key);
				}
			} catch (JoftiException e){
				log.error("Add Event: Unable to add index value for key "+key,e);
				// should we remove the value if we cannot add it?
			}finally {
				base.releaseUpdateLock();
			}
			
			
		} catch (Exception e){
			log.error(e);
		}
		
		
		
		
	}

}
