/*
 * Created on 30-Oct-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.cache.adapter.listener;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.cache.IBaseAdaptor;
import com.jofti.core.InternalIndex;
import com.jofti.exception.JoftiException;

/**
 * The Class used to provide the connection between the adapter and the Cache for Listener adapters. </p>
 * The Listener is for EHCache 1.2 and above. </p>
 * @author xenephon
 * @version 1.8
 * @since 1.1
 *
 */
public class EhEventListener implements CacheEventListener{

	/* (non-Javadoc)
	 * @see net.sf.ehcache.event.CacheEventListener#notifyElementRemoved(net.sf.ehcache.Cache, net.sf.ehcache.Element)
	 */
	IBaseAdaptor base = null;
	
    private static Log                  log = LogFactory
    .getLog(EhEventListener.class);
    
    
    
public EhEventListener(IBaseAdaptor base){
	this.base =base;
}
	
	
	/* (non-Javadoc)
	 * @see net.sf.ehcache.event.CacheEventListener#notifyElementRemoved(net.sf.ehcache.Cache, net.sf.ehcache.Element)
	 */
	public void notifyElementRemoved(Ehcache arg0, Element arg1) {
		if (arg1 == null){
			return;
		}
		Object key = arg1.getKey();
		
		key = base.decorateKey(key);
		try {
			base.acquireUpdateLock();
			try {
				
				// lock on the key lock - so we do not get other threads interfering for the same/similar
				// key
				synchronized(base.getCacheLock(key))
				{
					base.getIndex().removeByKey((Comparable)key);
				}
				if (log.isDebugEnabled()){
					log.debug("Remove event: removed from index "+key );
				}
			} catch (JoftiException e){
				log.error("Remove event: Unable to remove value for key "+key,e);
			 }finally {
			 	base.releaseUpdateLock();
			}
		
		} catch (Exception e){
			log.error("unable to aquire update lock",e);
		}
		
	}

	/* (non-Javadoc)
	 * @see net.sf.ehcache.event.CacheEventListener#notifyElementPut(net.sf.ehcache.Cache, net.sf.ehcache.Element)
	 */
	public void notifyElementPut(Ehcache arg0, Element arg1) {
		if (arg1 == null){
			return;
		}
		
		Object key = arg1.getKey();
		Object value = arg1.getValue();
		key = base.decorateKey(key);
		
		if (key == null){
			throw new RuntimeException("key is null for put "+ arg1);
		}
		try {
			base.acquireUpdateLock();
			try {
				InternalIndex index = base.getIndex();
				synchronized(base.getCacheLock(key))
				{
				    				
					// insert into the index
					index.insert(key,value);
				}
				if (log.isDebugEnabled()){
					log.debug("Add Event: entry added to index "+key + " value: "+ value);
				}
			} catch (JoftiException e){
				log.error("Add Event: Unable to add index value for key "+key,e);
				// should we remove the value if we cannot add it?
			}finally {
				base.releaseUpdateLock();
			}
			
			
		} catch (Exception e){
			log.error(e);
		}
		
		
	}

	/* (non-Javadoc)
	 * @see net.sf.ehcache.event.CacheEventListener#notifyElementExpired(net.sf.ehcache.Cache, net.sf.ehcache.Element)
	 */
	public void notifyElementExpired(Ehcache arg0, Element arg1) {
		if (arg1 == null){
			return;
		}
		Object key = arg1.getKey();
		//Object value =  arg1.getValue();
		key = base.decorateKey(key);
		try {
			base.acquireUpdateLock();
			try {
				
				// lock on the key lock - so we do not get other threads interfering for the same/similar
				// key
				synchronized(base.getCacheLock(key))
				{
					base.getIndex().removeByKey((Comparable)key);
				}
			//	log.info("Flush Event: removed from index "+key + " value "+ value);
				if (log.isDebugEnabled()){
					log.debug("Expire Event: removed from index "+key );
				}
			} catch (JoftiException e){
				log.error("Expire event: Unable to remove value for key "+key,e);
			 }finally {
			 	base.releaseUpdateLock();
			}
		
		} catch (Exception e){
			log.error("unable to aquire update lock",e);
		}
		
	}


    /* (non-Javadoc)
     * @see net.sf.ehcache.event.CacheEventListener#notifyElementUpdated(net.sf.ehcache.Cache, net.sf.ehcache.Element)
     */
    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException
    {
    	if (element == null){
			return;
		}
        Object key = element.getKey();
        Object value = element.getValue();
        key = base.decorateKey(key);
        
        if (key == null){
            throw new RuntimeException("key is null for put "+ element);
        }
        try {
            base.acquireUpdateLock();
            try {
                InternalIndex index = base.getIndex();
                synchronized(base.getCacheLock(key))
                {
                   
                        if (log.isDebugEnabled()) {
                            log.debug("Object does exist so remove " + key);
                        }
                    
                        // null op if it does not exist
                        index.removeByKey(key);
                                 
                        // insert into the index
                        index.insert(key,value);
                }
                if (log.isDebugEnabled()){
                    log.debug("Add Event: entry added to index "+key + " value: "+ value);
                }
            } catch (JoftiException e){
                log.error("Add Event: Unable to add index value for key "+key,e);
                // should we remove the value if we cannot add it?
            }finally {
                base.releaseUpdateLock();
            }
            
            
        } catch (Exception e){
            log.error(e);
        }
        
        
    }

    public Object clone(){
    	return null;
    }

    public void dispose()
    {
       // we do not have to do anything here
        
    }


    public void notifyElementEvicted(Ehcache arg0, Element arg1)
    {
        // we do not care
        
    }


    public void notifyRemoveAll(Ehcache arg0)
    {
        try {
            base.acquireUpdateLock();
            try {
                InternalIndex index = base.getIndex();
                index.removeAll();
            } catch (JoftiException e){
                log.error("Add Event: Unable to remove all values ");
                // should we remove the value if we cannot add it?
            }finally {
                base.releaseUpdateLock();
            }
        } catch (Exception e){
            log.error(e);
        }
    }
	
}


