/*
 * Created on 30-Oct-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.cache.adapter.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.cache.IBaseAdaptor;
import com.jofti.core.InternalIndex;
import com.jofti.exception.JoftiException;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;

/**
 * The Class used to provide the connection between the adapter and the Cache for Listener adapters. </p>
 * The Listener is for OSCache. </p>
 * 
 * @author xenephon
 * @version 1.0
 */
public class OSEventListener implements CacheEntryEventListener {

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheEntryAdded(com.opensymphony.oscache.base.events.CacheEntryEvent)
	 */
	IBaseAdaptor base = null;

	private static Log log = LogFactory.getLog(OSEventListener.class);

	public OSEventListener(IBaseAdaptor base) {
		this.base = base;
	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheEntryAdded(com.opensymphony.oscache.base.events.CacheEntryEvent)
	 */
	public void cacheEntryAdded(CacheEntryEvent arg0) {
		// get the key
		String key = arg0.getKey();
		Object value = arg0.getEntry().getContent();

		try {
			base.acquireUpdateLock();
			try {

				synchronized (base.getCacheLock(key)) {
					// insert into the index
					base.getIndex().insert(key, value);
				}
				if (log.isDebugEnabled()) {
					log.debug("Add Event: entry added to index " + key
							+ " value: " + value);
				}
			} catch (JoftiException e) {
				log.error(
						"Add Event: Unable to add index value for key " + key,
						e);
				// should we remove the value if we cannot add it?
			} finally {
				base.releaseUpdateLock();
			}

		} catch (Exception e) {
			log.warn(e);
		}

	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheEntryFlushed(com.opensymphony.oscache.base.events.CacheEntryEvent)
	 */
	public void cacheEntryFlushed(CacheEntryEvent arg0) {
		String key = arg0.getKey();

		try {
			base.acquireUpdateLock();
			try {

				// lock on the key lock - so we do not get other threads interfering for the same/similar
				// key
				synchronized (base.getCacheLock(key)) {
					base.getIndex().removeByKey((Comparable) key);
				}
				//	log.info("Flush Event: removed from index "+key + " value "+ value);
				if (log.isDebugEnabled()) {
					log.debug("Flush Event: removed from index " + key);
				}
			} catch (JoftiException e) {
				log.error("Flush event: Unable to remove value for key " + key,
						e);
			} finally {
				base.releaseUpdateLock();
			}

		} catch (Exception e) {
			log.error("unable to aquire update lock", e);
		}

	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheEntryRemoved(com.opensymphony.oscache.base.events.CacheEntryEvent)
	 */
	public void cacheEntryRemoved(CacheEntryEvent arg0) {
		String key = arg0.getKey();

		try {
			base.acquireUpdateLock();
			try {

				// lock on the key lock - so we do not get other threads interfering for the same/similar
				// key
				synchronized (base.getCacheLock(key)) {
					base.getIndex().removeByKey((Comparable) key);
				}
				if (log.isDebugEnabled()) {
					log.debug("Remove event: removed from index " + key);
				}
			} catch (JoftiException e) {
				log.error(
						"Remove event: Unable to remove value for key " + key,
						e);
			} finally {
				base.releaseUpdateLock();
			}

		} catch (Exception e) {
			log.error("unable to aquire update lock", e);
		}
	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheEntryUpdated(com.opensymphony.oscache.base.events.CacheEntryEvent)
	 */
	public void cacheEntryUpdated(CacheEntryEvent arg0) {
		String key = arg0.getKey();
		Object value = arg0.getEntry().getContent();

		InternalIndex index = base.getIndex();
		try {
			base.acquireUpdateLock();
			try {

				//lock on the key lock - so we do not get other threads interfering for the same/similar
				// key
				synchronized (base.getCacheLock(key)) {
					index.removeByKey(key);
					index.insert(key, value);
				}
				if (log.isDebugEnabled()) {
					log.debug("Update event: inserted into index " + key
							+ " value " + value);
				}
			} catch (JoftiException e) {
				log.error("Update event: Unable to index value for key " + key,
						e);
			} finally {
				base.releaseUpdateLock();
			}

		} catch (Exception e) {
			log.error("unable to aquire update lock", e);
		}
	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheGroupFlushed(com.opensymphony.oscache.base.events.CacheGroupEvent)
	 */
	public void cacheGroupFlushed(CacheGroupEvent arg0) {
		// we do not care about this
		log.debug("IndexCache group  flushed");

	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cachePatternFlushed(com.opensymphony.oscache.base.events.CachePatternEvent)
	 */
	public void cachePatternFlushed(CachePatternEvent arg0) {
		// we do not care about this
		log.debug("IndexCache pattern flushed");
	}

	/* (non-Javadoc)
	 * @see com.opensymphony.oscache.base.events.CacheEntryEventListener#cacheFlushed(com.opensymphony.oscache.base.events.CachewideEvent)
	 */
	public void cacheFlushed(CachewideEvent arg0) {

		log.debug("All IndexCache flushed");

	}

}
