package com.jofti.cache.adapter.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.websphere.objectgrid.ObjectGridException;
import com.ibm.websphere.objectgrid.ObjectGridRuntimeException;
import com.ibm.websphere.objectgrid.ObjectMap;
import com.ibm.websphere.objectgrid.TxID;
import com.ibm.websphere.objectgrid.plugins.LogElement;
import com.ibm.websphere.objectgrid.plugins.LogSequence;
import com.ibm.websphere.objectgrid.plugins.MapEventListener;
import com.ibm.websphere.objectgrid.plugins.index.MapIndexInfo;
import com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin;
import com.jofti.api.Index;
import com.jofti.api.IndexQuery;
import com.jofti.cache.IBaseAdaptor;
import com.jofti.core.GenericIndexFactory;
import com.jofti.core.IParsedQuery;
import com.jofti.core.InternalIndex;
import com.jofti.exception.JoftiException;
import com.jofti.util.ObjectProcedureAdapter;
import com.jofti.util.OpenHashMap;

/**
 * The Class used to provide the connection between the adapter and the Cache for Listener adapters. </p>
 * The Listener is for ObjectGrid and above. </p>
 * @author xenephon
 * @version 1.2
 * @since 1.2
 *
 */
public class ObjectGridEventListener implements MapIndexPlugin, MapEventListener {

	IBaseAdaptor base = null;
	String name;
	
	
	 private static Log                  log = LogFactory
	    .getLog(CoherenceEventListener.class);
	
	 public ObjectGridEventListener(IBaseAdaptor base, String name) {
			this.base = base;
			this.name =name;
			
		
			
		}
	 
	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#doBatchUpdate(com.ibm.websphere.objectgrid.TxID, com.ibm.websphere.objectgrid.plugins.LogSequence)
	 */
	public void doBatchUpdate(TxID arg0, LogSequence arg1)
			throws ObjectGridRuntimeException {
		
		if (log.isDebugEnabled()){
			log.debug("transaction id:"+arg0 + " number of entries " +arg1.size());
		}
		if (arg1.isDirty() && arg1.size() >0)
		{
			try {
				base.acquireUpdateLock();
				
	//			 do deletes first
				Iterator it = arg1.getAllChanges();
				
				while(it.hasNext()){
					LogElement element = (LogElement)it.next();
					
					switch(element.getType().getCode()){
					case LogElement.CODE_DELETE:
					case LogElement.CODE_EVICT:
						if (log.isDebugEnabled()){
							log.debug("delete or eviction for "+ element.getCacheEntry().getKey());
						}
						elementRemoved(element.getCacheEntry().getKey(), null);
						break;
					case LogElement.CODE_INSERT:
						if (log.isDebugEnabled()){
							log.debug("insert for "+ element.getCacheEntry().getKey());
						}
						elementAdded(element.getCacheEntry().getKey(),element.getCurrentValue());
						break;
					case LogElement.CODE_UPDATE:
						if (log.isDebugEnabled()){
							log.debug("update for "+ element.getCacheEntry().getKey());
						}
						elementUpdated(element.getCacheEntry().getKey(),element.getCurrentValue());
						break;
					default:
						if (log.isDebugEnabled()){
							log.debug("event ignored for "+ element.getCacheEntry().getKey());
						}
						break;
					}
				}
	
				
			} catch (JoftiException e){
				log.error("bulk update event: Unable to complete update for tx:"+arg0,e);
			 }finally {
			 	base.releaseUpdateLock();
			}
		}
	

	}

	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#getIndexProxy(com.ibm.websphere.objectgrid.plugins.index.MapIndexInfo)
	 */
	public Object getIndexProxy(MapIndexInfo arg0) {
		
		return new BaseIndexProxy(arg0);
	}

	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#getName()
	 */
	public String getName() {
		
		return name;
	}

	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#setAttributeName(java.lang.String)
	 */
	public void setAttributeName(String arg0) {
		// NO-OP

	}

	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#undoBatchUpdate(com.ibm.websphere.objectgrid.TxID, com.ibm.websphere.objectgrid.plugins.LogSequence)
	 */
	public void undoBatchUpdate(TxID arg0, LogSequence arg1)
			throws ObjectGridException {
		if (log.isDebugEnabled()){
			log.debug("transaction id:"+arg0 + " number of entries " +arg1.size());
		}
		List errors = new ArrayList();
		if (arg1.isDirty() && arg1.size() >0)
		{
			try {
				base.acquireUpdateLock();
				
	//			 do deletes first
				Iterator it = arg1.getAllChanges();
				
				while(it.hasNext()){
					LogElement element = (LogElement)it.next();
					try {
						switch(element.getUndoType().getCode()){
						case LogElement.CODE_DELETE:
							if (log.isDebugEnabled()){
								log.debug("delete undo for "+ element.getCacheEntry().getKey());
							}
							elementRemoved(element.getCacheEntry().getKey(), null);
							break;
						case LogElement.CODE_INSERT:
							if (log.isDebugEnabled()){
								log.debug("insert undo for "+ element.getCacheEntry().getKey());
							}
							elementAdded(element.getCacheEntry().getKey(),element.getBeforeImage());
							break;
						case LogElement.CODE_UPDATE:
							if (log.isDebugEnabled()){
								log.debug("update undo for "+ element.getCacheEntry().getKey());
							}
							elementUpdated(element.getCacheEntry().getKey(),element.getBeforeImage());
							break;
						default:
							if (log.isDebugEnabled()){
								log.debug("event ignored for "+ element.getCacheEntry().getKey());
							}
							break;
						}
					} catch (Exception e){
						log.error("error undoing change "+element);
						errors.add(element.getCacheEntry().getKey());
					}
				}
	
				
			} catch (JoftiException e){
				log.error("bulk update event: Unable to complete update for tx:"+arg0,e);
			 }finally {
			 	base.releaseUpdateLock();
			}
			 if (errors.size() >0){
				 throw new ObjectGridException("error undoing transaction changes for:"+ errors);
			 }
		}
	


	}
	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.MapEventListener#entryEvicted(java.lang.Object, java.lang.Object)
	 */
	public void entryEvicted(Object arg0, Object arg1) {
		
		try {
			base.acquireUpdateLock();
			
			elementRemoved(arg0,arg1);
			
		} catch (JoftiException e){
			log.error("bulk update event: Unable to complete update for tx:"+arg0,e);
		 }finally {
		 	base.releaseUpdateLock();
		}
		
		
	}
	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.MapEventListener#preloadCompleted(java.lang.Throwable)
	 */
	public void preloadCompleted(Throwable arg0) {
		// ??
		
	}
	
	private void elementRemoved(Object key, Object value) throws JoftiException {

		key = base.decorateKey(key);

		synchronized(base.getCacheLock(key))
		{
			base.getIndex().removeByKey((Comparable) key);
		}

		if (log.isDebugEnabled()) {
			log.debug("Remove event: removed from index " + key);
		}

	}
	
	
	
	
	private void elementAdded(Object key, Object value) throws JoftiException {

		key = base.decorateKey(key);

		InternalIndex index = base.getIndex();

		synchronized(base.getCacheLock(key))
		{
			// insert into the index
			index.insert(key, value);
		}

		if (log.isDebugEnabled()) {
			log.debug("Add Event: entry added to index " + key + " value: "
					+ value);
		}

	}
	
	private void elementUpdated(Object key, Object value) throws JoftiException {

		key = base.decorateKey(key);

		InternalIndex index = base.getIndex();

		synchronized(base.getCacheLock(key))
		{
			// remove all entries first
			index.removeByKey(key);
			// insert into the index
			index.insert(key, value);
		}

		if (log.isDebugEnabled()) {
			log.debug("Add Event: entry added to index " + key + " value: "
					+ value);
		}

	}

	/**
	 * <p>
	 * The proxy provides the implementation for the object returned from the getIndexProxy method. 
	 * The proxy is repsonsible for mediating the queries with the ObjectGridAdapter and dealing with 
	 * modification of the committed result set with the current transaction scoped results.
	 * </p>
	 * <p>
	 * A new query run on the proxy results in a temporary index being built on those entries in the transaction 
	 * that have been inserted or updated.
	 * </p>
	 * <p>
	 * The general sequence is to:
	 * <ul>
	 * <li>Run the query against the committed index
	 * <li>remove the entries that have been marked as remove in this transaction
	 * <li> build a temporary index on the inserted and updated values
	 * <li>query the temp index
	 * <li>merge the results
	 * <li>apply any of the paging/maxresults logic
	 * </ul>
	 * 
	 * @author steve
	 *
	 */
	class BaseIndexProxy implements Index{

		MapIndexInfo info =null;
		
		BaseIndexProxy(MapIndexInfo info){
			this.info = info;
		}
		
		/* (non-Javadoc)
		 * @see com.jofti.api.Index#addQuery(java.lang.String, com.jofti.api.IndexQuery)
		 */
		public IndexQuery addQuery(String name, IndexQuery query) throws JoftiException {
			
			return ((Index)base).addQuery(name, query);
		}

		/* (non-Javadoc)
		 * @see com.jofti.api.Index#getQuery(java.lang.String)
		 */
		public IndexQuery getQuery(String name) {
			return ((Index)base).getQuery(name);
		}

		/* (non-Javadoc)
		 * @see com.jofti.api.Index#query(com.jofti.api.IndexQuery)
		 */
		public Map query(IndexQuery query) throws JoftiException {
			
			
			if (info ==null){
				return ((Index)base).query(query);
			}
			// decorate the results here
			List txChanges = info.getTransactionChanges(true);
			
			// loop through and build temp index
			InternalIndex localIndex = GenericIndexFactory.getInstance().createIndex(base.getIndex().getClass().getName(), 
					base.getIndex().getIntrospector(), new Properties(), "local");
			
			
			final ObjectMap objectMap = info.getMap();
			// query temp index 
			final Map res = ((Index)base).query(query);
			
			
			
			for (int i=0;i<txChanges.size();i++){
				LogElement element = (LogElement)txChanges.get(i);
				if (element.getType().getCode() == LogElement.CODE_DELETE ||
						element.getType().getCode() == LogElement.CODE_UPDATE){
					res.remove(element.getCacheEntry().getKey());
				}
				if (element.getType().getCode() == LogElement.CODE_INSERT ||
						element.getType().getCode() == LogElement.CODE_UPDATE){
					localIndex.insert(element.getCacheEntry().getKey(), element.getCurrentValue());
				}
			}
			// merge results
			IParsedQuery parsedQuery = (IParsedQuery)base.processQuery(query, base.getIndex().getParserManager());
			
			OpenHashMap localRes = (OpenHashMap)localIndex.query(parsedQuery);
			
			// merge results
			localRes.forEachPair(new ObjectProcedureAdapter() {
				
				public boolean apply(Object key, Object value) throws RuntimeException{
					try {
						res.put(key, objectMap.get(key));
					} catch(ObjectGridException e){
						log.error("Failure retrieving value in transaction:"+key,e);
					}
					return true;
				}
			});
			if (parsedQuery.getMaxResults() >0 || parsedQuery.getFirstResult() >0){
				return base.limitResults(res, parsedQuery.getFirstResult(), parsedQuery.getMaxResults() );
			}else{			
				return res;
			}
		}
		
	}

}
