/*
 * Created on 08-Apr-2005
 *
 */
package com.jofti.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;



/**
 
 * 
 * A convenience class for use in the addIndex method. The default config already has the default entries 
 * in each of the configuration properties. The only thing not present are any class mappings - so 
 * no changes to this object will result in only the built-in types being indexed.<p>
 * 
 The settings are:
<ul>
<li>name: default
<li>adapter: com.jofti.cache.adapter.MapAdapter
<li>parserType: com.jofti.introspect.JavaBeanClassIntrospector
<li>indexType: com.jofti.tree.TreeIndex
<li>ClassMappings: [ ]
<li>queryMappings: [ ]
<li>adapterProperties: [ ]
</ul> 
 *
 *
 *
 * @author Steve Woodcock (steve@jofti.com)<p>
 * @version 1.0
 */
public class DefaultIndexConfig implements IndexConfig {


	//set up the default values
	
    private String name="default";
	
	private String cacheAdapter = "com.jofti.cache.adapter.MapAdapter";
    
	
	private String indexType = "com.jofti.tree.TreeIndex";
	
	private String parserType = "com.jofti.introspect.JavaBeanClassIntrospector";
	
	private Map classMappings = new ConcurrentHashMap();
	
	private Map queryMappings = new ConcurrentHashMap();
	
	private boolean lazyLoaded = false;
	
	private Properties adapterProperties;
	
	private Properties indexProperties = new Properties();
	
    
	public DefaultIndexConfig(){
		
	}
	
	/* (non-Javadoc)
	 * @see com.jofti.config.IndexConfig#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see com.jofti.conf.CacheConfig#getCacheAdapter()
	 */
	public String getCacheAdapter() {
		return cacheAdapter;
	}


	/* (non-Javadoc)
	 * @see com.jofti.conf.CacheConfig#getIndexMappings()
	 */
	public Map getIndexMappings() {
		return classMappings;
	}
	
	
	/* (non-Javadoc)
	 * @see com.jofti.config.IndexConfig#addMapping(java.lang.String, java.util.List)
	 */
	public void addMapping(String clazz, List propertyList){
 
        classMappings.put(clazz, propertyList);
	}

	/* (non-Javadoc)
	 * @see com.jofti.config.IndexConfig#addQuery(java.lang.String, java.lang.String)
	 */
	public void addQuery(String name, String query){
 
        queryMappings.put(name, query);
	}

	/**
	 * @param cacheAdapter The cacheAdapter to set.
	 */
	public void setCacheAdapter(String cacheAdapter) {
		this.cacheAdapter = cacheAdapter;
	}
	/**
	 * @param indexType The indexType to set.
	 */
	public void setIndexType(String indexType) {
		this.indexType = indexType;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the classMappings.
	 */
	public Map getClassMappings() {
		return classMappings;
	}
	
	/**
	 * @return Returns the queryMappings.
	 */
	public Map getQueryMappings() {
		return queryMappings;
	}
	/**
	 * @return Returns the indexType.
	 */
	public String getIndexType() {
		return indexType;
	}
	/**
	 * @return Returns the lazyLoaded.
	 */
	public boolean isLazyLoaded() {
		return lazyLoaded;
	}
	/**
	 * @param lazyLoaded The lazyLoaded to set.
	 */
	public void setLazyLoaded(boolean lazyLoaded) {
		this.lazyLoaded = lazyLoaded;
	}
	/**
	 * @return Returns the adapterProperties.
	 */
	public Properties getAdapterProperties() {
		return adapterProperties;
	}
	/**
	 * @param adapterProperties The adapterProperties to set.
	 */
	public void setAdapterProperties(Properties adapterProperties) {
		this.adapterProperties = adapterProperties;
	}

	/* (non-Javadoc)
	 * @see com.jofti.config.IndexConfig#getParserType()
	 */
	public String getParserType() {
		return parserType;
	}
	/**
	 * @param parserType The parserType to set.
	 */
	public void setParserType(String parserType) {
		this.parserType = parserType;
	}

	/* (non-Javadoc)
	 * @see com.jofti.config.IndexConfig#getPersistenceProperties()
	 */
	public Properties getIndexProperties() {

		return indexProperties;
	}


	public synchronized void setIndexProperties(Properties indexProperties) {
		this.indexProperties = indexProperties;
	}


}
