/*
 * Created on 08-Apr-2005
 *
 */
package com.jofti.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;


/**
 * 
 *
 * Configuration interface for Jofti. The config object supplies the index to be created, 
 * the properties for the index and the classes to index. The class also provides for 
 * pass through configuration for the IndexCache Implmenetation as each IndexCache requires its config file 
 * in a different format.<p>
 * 
 * This interface is used in the programmatic addition of a cache to Jofti.
 * 
 * @author Steve Woodcock (steve@jofti.com)<p>
 * @version 1.0
 */
public interface IndexConfig {

	/**
     * The name of the cache to be added.
     * 
	 * @return name of IndexCache
	 */
	public String getName();
	
	/**
     * The cacheAdapter implementation to use.<p>
	 * @return String representation for the adapter
	 */
	public String getCacheAdapter();	
	
	/**
     * Returns a Map of the index mappings. Format is String class name as akey to a List of 
     * String filed names as defined in the config XMl examples. See user guide for examples.<p>
	 * @return map of indexed classes.
	 */
	public Map getIndexMappings();
	
	/**
     * Returns a Map of the query mappings. Format is String class name as a key to a query. See user guide for examples.<p>
	 * @return map of indexed classes.
	 */
	public Map getQueryMappings();
    
	/**
     * Adds a mapping entry to the IndexCache Mapping Map. The format is 
     * key as String classname
	 * @param clazz
	 * @param propertyList
	 */
	public void addMapping(String clazz, List propertyList);
	    
	
	/**
     * Adds a mapping entry to the IndexCache Mapping Map. The format is 
     * key as String classname
	 * @param clazz
	 * @param propertyList
	 */
	public void addQuery(String name, String query);
	
	
	/**
     * Returns the IndexCache type to use.
	 * @return the index type.
	 */
	public String getIndexType();
	
	public boolean isLazyLoaded();
	
	/**
     * returns any properties for the adapter.
	 * @return A property object
	 */
	public Properties getAdapterProperties();
	
	/**
     * returns the object introspector type.
	 * @return the introspector class name
	 */
	public String getParserType();
	
	public Properties getIndexProperties();
    
    
    
	
}
