/*
 * Created on 03-Apr-2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.jofti.core;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.jofti.btree.BTree;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.manager.IndexManagerImpl;
import com.jofti.tree.TreeIndex;
import com.jofti.util.ReflectionUtil;

/**

 *
 * Used to produce indexes. The IndexCache is not initialised when created.<p>
 * 
 * @author xenephon (xenephon@jofti.com)
 * @version 1.0
 */
public class GenericIndexFactory {
	
	private static GenericIndexFactory factory = new GenericIndexFactory();
	
	  
	 private static Log log     = LogFactory.getLog(IndexManagerImpl.class);
	 
	public static GenericIndexFactory getInstance(){
		return factory;
	}
	
	/**
	 * creates an Index of the type passed in IndexType.<p>
	 * 
	 * @param indexType
	 * @param parser
	 * @param props
	 * @return The Index created by the factory
	 * @throws JoftiException
	 */
	public InternalIndex createIndex(String indexType,
			ClassIntrospector parser, Properties props, String name)
			throws JoftiException {
		InternalIndex index =null;
		try {
			Class indexClass = ReflectionUtil.classForName(indexType);

			if (!(InternalIndex.class.isAssignableFrom(indexClass))) {
				throw new JoftiException("Class '" + indexClass
						+ "' must implement Index interface ");
			}
		
			index = (InternalIndex)indexClass.newInstance();
			
		} catch (InstantiationException e) {
			throw new JoftiException("Problem instantiating Index", e);
		} catch (ClassNotFoundException e) {
			throw new JoftiException("Problem finding Index class", e);
		} catch (IllegalAccessException e) {
			throw new JoftiException("Problem instantiating Index", e);
		} catch (Exception e) {
			throw new JoftiException("Problem calling init() method on Index '"
					+ indexType + "'", e);

		}
		IStoreManager manager =null;
		try{
			manager = configureOverflowManager(props,name);
		} catch (InstantiationException e) {
			throw new JoftiException("Problem instantiating disk-overflow provider " +props, e);
		} catch (ClassNotFoundException e) {
			throw new JoftiException("Problem instantiating disk-overflow provider "+props, e);
		} catch (IllegalAccessException e) {
			throw new JoftiException("Problem instantiating disk-overflow provider "+props, e);
		} catch (Exception e) {
			throw new JoftiException("Problem calling init() method on overflow provider '"
					+ name + "'", e);

		}
			
			
			
			
			
			if (index instanceof TreeIndex){

				BTree bTree = new BTree();
				((TreeIndex)index).setTree(bTree);
				((TreeIndex)index).setParser(parser);
				
				if (manager != null){
					bTree.setOverflowManager(manager);
				}
				
			}
			((TreeIndex)index).init(props);

			return index;
		
		
		
	}
	
	private IStoreManager configureOverflowManager(Properties props,String name) throws Exception{
		
		String providerString = props.getProperty("provider");
		Class providerClass = null;
		if (providerString != null){
			providerClass =ReflectionUtil.classForName(providerString);
		}
		IStoreManager manager = null;
		
		if (providerClass != null){
			manager = (IStoreManager) providerClass.newInstance();
			
			if (manager != null){
				manager.setName(name);
				manager.init(props);
			}
	
		}
		return manager;
		
	}
	
}
