/*
 * Created on 20-Jul-2005
 *
 */
package com.jofti.core;

import java.util.Map;
import java.util.Stack;

import com.jofti.api.IndexQuery;
import com.jofti.util.CompositeComparator;

/**
 *
 * 
 * The parsed query format that results from the query parser.<p>
 *
 * @author Steve Woodcock (steve@jofti.com)<p>
 * @version 1.0
 */
public interface IParsedQuery extends IndexQuery{
	public abstract Class getClassName();

	/**
	 * Geta map of the alias entries in the query. I.e classes that are 
	 * 'com.foo.Bar AS B' parts of the query
	 * 
	 * @return the map of classnames to alias'
	 */
	public abstract Map getAliasMap();
	
	/**
	 * @return Returns the predicates.
	 */
	public abstract Stack getPredicates();
    
    public abstract Map getResultFieldsMap();
    
    public abstract Map getNamedValueMap();
    
    public abstract Object getNameSpace();
    
    public abstract CompositeComparator getOrderingComparator();
    
    public int getFirstResult();
    
    public int getMaxResults();
}