package com.jofti.core;

import com.jofti.store.FilePositionHolder;

/**
 * <p>Interface defining key used by PagdLeafNodes to store and retrieve Page data.</p>
 * <p>
 * Each Key contains an array of file positions and an id which is unique for the key.
 * </p> 
 * @author xenephon
 *
 */
public interface IStoreKey {

	public long getId();
		
	public FilePositionHolder[] getFilePositions();
    
    public boolean isNewKey();
    
    public void setNewKey(boolean newKey);
    
    public void setFilePositions(FilePositionHolder[] positions);    
    
    public Object clone();
    
    public void setNumber(int number);
    
    public int getNumber();
}
