/*
 * Created on 01-Jan-2005
 *
 */
package com.jofti.introspect;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.jofti.config.IndexConfig;
import com.jofti.exception.JoftiException;

/**
 *
 * 
 * Internal Interface used by the index implementations to obtain information about the 
 * Classes and objects to be indexed.<p>
 *
 * @author Steve Woodcock (Steve@jofti.com)
 * @version 1.0
 */
public interface ClassIntrospector {

	 /**
	  * Parses the IndexConfig ovject to retrieve the class mappings to be used in the introspector.
	 * @param config
	 * @throws JoftiException
	 */
	public void parseConfig(IndexConfig config) throws JoftiException;
	 
	 /**
	  * Returns the dimension in the introspector for the class and property name.<p>
	  * Key dimensions are negative and property dimenions are positive.
	 * @param className
	 * @param propertyName
	 * @return an int value representing dimensions.
	 * @throws JoftiException
	 */
	public int getDimension(String className, String propertyName) throws JoftiException;
	 
	
	public int getDimension(Class clazz, String propertyName) throws JoftiException;
	
	 /**
	  Returns the dimension in the introspector for the class.<p>
	  * Key dimensions are negative.
	 * @param className
	 * @return an int representing the dimension
	 */
	public int getKeyDimension(Class className);
	 
	 /**
	  * A map containing all the key dimensions and classes.
	 * @return a Map
	 */
	public Map getKeyDimensions();
	
	/**
	  * A map containing all the non-key dimensions and classes.
	 * @return a Map
	 */
	public Map getDimensions();
	 
	 /**
	  * Takes an object and returns a Map containing the values of the to be indexed properties in that class. The values are 
	  * obtained by introspection from the class. The keys are dimesnions and the value is the actual value in the object for that dimension.<p>
	 * @param obj - the object to be introspected.
	 * @return A map of dimension to value mappings
	 * @throws JoftiException
	 */
	public Map getAttributeValues(Object obj)throws JoftiException;
	 
	 /**
	  * Returns all the primitive classes the introspector has registered.
	 * @return a set of class names.
	 */
	public Set getPrimitiveClasses();
	 
	/**
	 * 
	 * Gets the actual class that the className will return for the attribute name.
	 * @param className
	 * @param attribute
	 * @return the class of the return parameter.
	 * @throws JoftiException
	 */
	public Class getClassForAttribute(Class className, String attribute) throws JoftiException;
	
	
	public List getParsedObjectsForClass(Class clazz);
	
	 public Object[] getMethodsForAttribute(Class clazz,String attribute) throws JoftiException;
	 	 
	 public Object getResultFromMethods(Object obj, Object[] methods) throws JoftiException;
	 
	  public  Map getResultValuesFromObject(Map temp, Object obj,Map methodMap);
	  
	  public Class boxPrimitive(Class clazz);

}
