package com.jofti.introspect;

import java.util.ArrayList;
import java.util.List;

import com.jofti.model.ComparableBoolean;

/**
 * A set of util methods for dealing with Class type issues.
 * @author steve woodcock (steve@jofti.com)
 *
 */
public class ClassUtils
{

    /**
     * Iterates through a Class hierachy - starting at the Class passed in and retrieves 
     * all interfaces that are declared as part of the hierachy.
     * @param clazz
     * @return an Array of Interface Class objects
     */
    public Class[] getInterfaces(Class clazz){
        List temp = new ArrayList();
        temp = getAllInterfaces(temp,clazz);
       return (Class[]) temp.toArray(new Class[temp.size()]);
    }
    
    /**
     * Iterates through a Class hierachy - starting at the Class passed in and retrieves 
     * all Classes that are declared as part of the hierachy.
     * @param clazz
     * @return an Array of Class objects
     */
    public Class[] getClasses(Class clazz){
        List temp = new ArrayList();
        temp.add(clazz);
        Class superClazz = clazz.getSuperclass();
        while (superClazz != null){
        	temp.add(superClazz);
        	superClazz = superClazz.getSuperclass();
        }
       return (Class[]) temp.toArray(new Class[temp.size()]);
    }
    
    
    private List getAllInterfaces(List list,Class clazz){
        Class [] classes =clazz.getInterfaces();
        for (int i =0;i<classes.length;i++){
            list.add(classes[i]);
            if (classes[i].getInterfaces() != null){
                list = getAllInterfaces(list,classes[i]);
            }
        }
        return list;
    }
    
    
    /**
     * Wraps a Boolean object in a ComparableBoolean so it can be used in an Index.
     * 
     * @param tempObj
     * @return Either a ComparableBoolean wrapping a Boolean or the original Object if not Boolean.
     */
    public Object wrapObject(Object tempObj){
        if (tempObj instanceof Boolean){
                tempObj = new ComparableBoolean((Boolean)tempObj);
            }
        return tempObj;
    }
    
   
}
