/*
 * Created on 19-Apr-2004
 *
 */
package com.jofti.locking;

import com.jofti.btree.Node;
import com.jofti.exception.JoftiException;

import com.jofti.oswego.concurrent.ReadWriteLock;;

/**
 * Provides the locking and unlocking functions for the BTree nodes.<p>
 * 
 * @author Steve Woodcock
 *
 */
public class LockManager {
	
	public static final int WRITE_LOCK =1;
	public static final int READ_LOCK =2;
	

	
	private LockManager(){
		// not implemented as is a static helper
	}
	
	public static void acquireLock(Node node, int lockType) throws JoftiException{
		if (node != null){
			try {
				
				if (lockType == WRITE_LOCK){
					node.nodeLock.writeLock().acquire();
				}else{
					node.nodeLock.readLock().acquire();
				}
			} catch (InterruptedException ie){
				throw new JoftiException("Unable to acquire node lock on node "+node);
			}
		}
	}
    
    public static boolean attemptLock(Node node, int lockType, long time) throws JoftiException{
        if (node != null){
            try {
                if (lockType == WRITE_LOCK){
                    return node.nodeLock.writeLock().attempt(time);
                }else{
                    return node.nodeLock.readLock().attempt(time);
                }
            } catch (InterruptedException ie){
                throw new JoftiException("Unable to acquire node lock on node "+node);
            }
        }
        return false;
    }
	
	public static void acquireRWLock(ReadWriteLock lock, int lockType) throws JoftiException{
		if (lock != null){
			try {
				if (lockType == WRITE_LOCK){
					lock.writeLock().acquire();
				}else{
					lock.readLock().acquire();
				}
			} catch (InterruptedException ie){
				throw new JoftiException("Unable to acquire RW lock on lock " + lock);
			}
		}
	}
	
	public static void releaseRWLock(ReadWriteLock lock, int lockType){
		if (lockType == WRITE_LOCK){
			lock.writeLock().release();
		}else{
			lock.readLock().release();
		}
	}
	
	public static void releaseLock(Node node, int lockType){
		if (lockType == WRITE_LOCK){
			node.nodeLock.writeLock().release();
		}else{
			node.nodeLock.readLock().release();
		}
	}
	
	
    
   
    
	
}
