/*
 * ParsedObject.java
 *
 * Created on 17 August 2003, 10:21
 */

package com.jofti.model;


import java.util.Map;
/**
 *
 * Representation of a parsed object that is used by the introspector. 
 * @author  xenephon (xenephon@jofti.com)
 * 
 *  
 */
public class ParsedObject
{
    private Class classValue = null;
        
    private Map fieldValues = null;
    
    private Map dimensionClassMappings =null;
    
    private Map methodValues = null;
    
    private boolean isInterface =false;
    
    private boolean isProxy;
    
    private Map fieldMethods = null;
	
    /**
     * @return Returns the isInterface.
     */
    public boolean isInterface()
    {
        return isInterface;
    }

    /**
     * @param isInterface The isInterface to set.
     */
    public void setInterface(boolean isInterface)
    {
        this.isInterface = isInterface;
    }

    /**
     * @return Returns the isProxy.
     */
    public boolean isProxy()
    {
        return isProxy;
    }

    /**
     * @param isProxy The isProxy to set.
     */
    public void setProxy(boolean isProxy)
    {
        this.isProxy = isProxy;
    }

    /** Getter for property objectValue.
     * @return Value of property objectValue.
     *
     */
    public java.lang.Object getClassValue()
    {
        return classValue;
    }
    
    /** Setter for property objectValue.
     * @param objectValue New value of property objectValue.
     *
     */
    public void setClassValue(java.lang.Class objectValue)
    {
        this.classValue = objectValue;
    }
    

    /** Getter for property fieldValues.
     * @return Value of property fieldValues.
     *
     */
    public Map getFieldValues()
    {
        return fieldValues;
    }
    
    /** Setter for property fieldValues.
     * @param fieldValues New value of property fieldValues.
     *
     */
    public void setFieldValues(Map fieldValues)
    {
        this.fieldValues = fieldValues;
    }
    
 
    public void addField(Object key, Object field){
    		fieldValues.put(key,field);
    }
	/**
	 * @return Returns the methodValues.
	 */
	public Map getMethodValues() {
		return methodValues;
	}
	/**
	 * @param methodValues The methodValues to set.
	 */
	public void setMethodValues(Map methodValues) {
		this.methodValues = methodValues;
	}
	
	 public void addMethod(Object key, Object field){
		methodValues.put(key,field);
}
	public Map getDimensionClassMappings() {
		return dimensionClassMappings;
	}
	public void setDimensionClassMappings(Map dimensionClassMappings) {
		this.dimensionClassMappings = dimensionClassMappings;
	}
	public Map getFieldMethods() {
		return fieldMethods;
	}
	
	public void setFieldMethods(Map fieldMethods) {
		this.fieldMethods = fieldMethods;
	}
}
