/*
 * Created on 12-Jan-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.parser;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import antlr.collections.AST;

import com.jofti.core.IPredicate;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.util.ArrayComparator;
import com.jofti.util.CompositeComparator;
import com.jofti.util.ReflectionComparator;

/**
 * Provides the base functionality for other Parser types. 
 * 
 * @author xenephon
 * @version 1.2
 *
 */
public class AbstractParser {

	/**
	 * 
	 */
	protected ClassIntrospector introspector = null;
	protected Map compiledQueries = null;

	  protected Object lockObject = new Object();
		
     static final String NULL = "NULL";
    
     
     public AbstractParser(final int cachedQueries, ClassIntrospector introspector){
		 
     	this.introspector = introspector;
     	// cache of previously parsed queries
		compiledQueries = new LinkedHashMap(){
			
			private final int MAX_ENTRIES = cachedQueries;

		     protected boolean removeEldestEntry(Map.Entry eldest) {
		        return size() > MAX_ENTRIES;
		     }

		};
	 }
     
     
     
	/**
	 * Parses the where predicates.
	 * @param expression - start of the where query
	 * @param stack - the predicate stack
	 * @param query
	 * @return
	 * @throws JoftiException
	 */
	protected Stack parseWherePredicates(AST expression, Stack stack, ParsedQuery query) throws JoftiException{
		
		// parse the first expression 
		AST subExpression = parseExpression(expression, stack, query);
		
		// keep going while we have a predicate to parse
		while (subExpression != null){
			
			subExpression = parseExpression(subExpression,stack, query);
		}
		return stack;
	}
	
	// parse an individual statement
	protected AST parseExpression(AST expression, Stack stack, ParsedQuery parsedQuery) throws JoftiException{
		
		// is the expression joined via a boolean operator?
		if (expression.getType() == CommonLexerTokenTypes.AND || expression.getType() == CommonLexerTokenTypes.OR){
			// we have joined statements
		
		stack.push(new Operator(expression.getType()));
		return expression.getNextSibling();	
		
		// is it a grouped expression
	} else if (expression.getType() == CommonLexerTokenTypes.LPAREN){
		
		// parse the subpredicate
		AST nextNode = parseSubPredicate(expression, parsedQuery, stack);
		return nextNode;
	} else if (expression.getType() == CommonLexerTokenTypes.RPAREN){
		// 
		return expression.getNextSibling();
	}else if (expression != null){
		
		 // we have a single predicate
		IPredicate predicate = constructPredicate(expression,parsedQuery);
		stack.push(predicate);
		return expression.getNextSibling();
	}
	return expression;
	

		
	}
	
	
	protected AST parseSubPredicate(AST expression,ParsedQuery query,Stack stack) throws JoftiException{
		
		Stack subStack = new Stack();
		
		// get next expression
		AST subExpression = expression.getNextSibling();
		// parse the expression
		subExpression = parseExpression(subExpression,subStack,query);
		while (subExpression != null && subExpression.getType() !=  CommonLexerTokenTypes.RPAREN){
			subExpression = parseExpression(subExpression,subStack,query);
		}
		if (subExpression != null && subExpression.getType() ==  CommonLexerTokenTypes.RPAREN){
			subExpression = subExpression.getNextSibling();
		}
		StackPredicate predicate = new StackPredicate();
		predicate.setPredicateStack(subStack);
		// set the predicate in the current stack
		stack.push(predicate);
		// return where we are in the tree
		
		return subExpression;
	}
	
	protected IPredicate constructPredicate(AST expression,ParsedQuery query) throws JoftiException{
		
		// set up the predicate
		Predicate temp = new Predicate();
		temp.setOperator(expression.getType());
		
		AST field = expression.getFirstChild();
		
		String realValue = field.getText();
		
		// 
		if(query.getAliasMap().size() >0){
			// we need to make sure that all fields have aliases
			int dotIndex = realValue.indexOf(".");
			if (dotIndex<0){
				throw new JoftiException("Alias prefix is missing from field "+ realValue);
			}else{
				//make sure the alias is in the map
				String alias = realValue.substring(0,dotIndex);
				if (query.getAliasMap().get(alias) == null){
					throw new JoftiException("Alias prefix is missing or incorrect from field "+ realValue);
				}else{
					// set the field into the predicate
					temp.setField(realValue.substring(dotIndex+1));
					temp.setAlias(alias);
				}
				
			}
			
		} else{
			temp.setField(realValue);
		}


		AST value = field.getNextSibling();

		if (value == null){
			throw new JoftiException("field name is missing from expression - check that you are not trying to use 'and' or 'or' as field names");
		}

		// if empty this could be valid
		if (value.getText().length() == 0){
			 temp.setValue(value.getText());
	   // else a named parameter could be present
		}else if (value.getText().charAt(0) == ':'  ){
			if (value.getText().length() <2){
				throw new JoftiException("Parameter "+ value.getText() + " must have an associated identifier");
			}
			temp.setValue(value.getText());
//			 check if numeric one is 
		}  else if ( value.getText().charAt(0) == '?'){
			if (value.getText().length() <2){
				throw new JoftiException("Parameter "+ value.getText() + " must have an associated identifier");
				
			}
			// see if it is a number
			try {
				Integer.parseInt(value.getText().substring(1));
			}catch (NumberFormatException nfe){
				throw new JoftiException("Parameter "+ value.getText() + " is not numeric");
			}
			temp.setValue(value.getText());
		}else if (temp.getOperator() == CommonLexerTokenTypes.IS || 
                temp.getOperator() == CommonLexerTokenTypes.NOT){
            if (!(NULL.equalsIgnoreCase(value.getText()) )){
                throw new JoftiException("Only value 'NULL' is supported for operators IS or NOT");
 
            }
            temp.setValue(value.getText());
        }else if (temp.getOperator() == CommonLexerTokenTypes.LIKE){
        	 if (!(value.getText().endsWith("%") || value.getText().length() <2 )){
                throw new JoftiException("Value must end with '%' for operator LIKE and contain at least 1 character prefix");
 
            }
             temp.setValue(value.getText());
        }else if (temp.getOperator() == CommonLexerTokenTypes.IN){
            
             if (value.getType() != CommonLexerTokenTypes.LPAREN ){
                    throw new JoftiException("argument for IN operator Collection must be of format (val1,val2,..,valn)");
     
                }
             
             List tempList = new ArrayList();
             while (value.getNextSibling() != null && value.getNextSibling().getType() != CommonLexerTokenTypes.RPAREN){
                 value = value.getNextSibling();
                 if (value.getType() != CommonLexerTokenTypes.COMMA){
                     tempList.add(value.getText());
                 }
             
            }
            temp.setValue(tempList);
        }else{
            temp.setValue(value.getText());
        }
        
		return temp;
		
	}

	
	protected Object[] getMethodsForProperty(Class singleClass, Map aliasMap,String alias) throws JoftiException{
		int aliasSeperator = alias.indexOf('.');
		
		Class clazz = null;
		
		if (singleClass == null){
			clazz= getClassForAlias(aliasMap, alias);
		}else{
			clazz = singleClass;
		}
		
		
		
		String attribute = alias.substring(aliasSeperator + 1, alias.length());
		if (clazz ==null){
			throw new JoftiException("attribute "+ alias + " must consist of Class.property and Class must be specified in from clause");
		}
		
		Object[] methods = introspector.getMethodsForAttribute(clazz,attribute);
		if (methods == null || methods.length ==0){
			// log.warn
			throw new JoftiException("Attribute "+ attribute + " is not valid for "+ clazz);
		}else{
			return methods;
		}

		
		
	}
	
	protected Class getClassForAlias(Map aliasMap, String alias)
	throws JoftiException {
int aliasSeperator = alias.indexOf('.');

if (aliasSeperator > 0) {
	String aliasObj = alias.substring(0, aliasSeperator);

	// we need to split them up
	Class clazz = (Class) aliasMap.get(aliasObj);
	if (clazz == null) {
		throw new JoftiException("identifier " + aliasObj 
				+ " in " + alias + " is not specified as a Class in from clause");

	}
	return clazz;
} else if (aliasSeperator == 0) {
	throw new JoftiException("Object identifier:" + alias
			+ " cannot start with '.'");
}
return null;
}
	
	protected int getIndexFor(Map aliasMap,Map returnMap,String alias) throws JoftiException{
		int aliasSeperator = alias.indexOf('.');
		
		Class clazz = getClassForAlias(aliasMap, alias);
		
		if (clazz ==null){
			throw new JoftiException("attribute "+ alias + " must consist of Class.property and Class must be specified in from clause");
		}
		
		ClassFieldMethods fieldSet = (ClassFieldMethods) returnMap.get(clazz);
		if (fieldSet == null) {
			throw new JoftiException("ordering class "+ clazz + " is not in select clause");
		} 
		
		String attribute = alias.substring(aliasSeperator + 1, alias.length());
		int i=-1;
		Iterator it = fieldSet.getFieldMap().keySet().iterator();
		
		for (int j=0;j<fieldSet.getFieldMap().size();j++){
			String key = (String)it.next();
			if (key.equals(attribute)){
				i =j;
			}
		}
		
		return i;
		
		
	}

	protected ParsedQuery parseOrder(AST expression, ParsedQuery query)
	throws JoftiException {

		// will be alias for field
		AST node = expression;
		boolean arrayIteratorType =false;
		// work out whether we need  object or array iterators
		if (query.getFieldReturnMap().size() >1){
			throw new JoftiException("ORDER BY clause is not allowed if multi-object return is specified");
		}else {
			//either fields or a whole object is specified
			Iterator it = query.getFieldReturnMap().values().iterator();
			for (int i=0;i<query.getFieldReturnMap().size();i++){
				ClassFieldMethods temp = (ClassFieldMethods)it.next();
				if (temp!= null && temp.getFieldMap() !=null && temp.getFieldMap().size() >0){
					// we are using array returns object
					arrayIteratorType =true;
				}
			}
		}
		
		node = node.getFirstChild().getNextSibling();

	do {
		// we have an as
	
		
		// put the aliases into the alias and return map
		CompositeComparator comp = query.getOrderingComparator();
		Comparator itemComp = null;
		
		if (arrayIteratorType){
			int index = getIndexFor(query.getAliasMap(),query.getFieldReturnMap(),node.getText().trim() );
			if (index <0){
				throw new JoftiException("ORDER BY attribute "+node.getText().trim() + " must be specified in select clause");
			}
			itemComp = new ArrayComparator(index);
		}else{
			Object[] methods =getMethodsForProperty(query.getClassName(),query.getAliasMap(), node.getText().trim());
			
			itemComp = new ReflectionComparator(methods,introspector);
		}
		
		
		node = node.getNextSibling();
		if (node != null){
			switch (node.getType()){
				case CommonLexerTokenTypes.ASC :
					comp.addComparator(itemComp);
					node = node.getNextSibling();
					break;
				case CommonLexerTokenTypes.DESC :
					comp.addComparator(itemComp,true);
					node = node.getNextSibling();
					break;
					default:
						comp.addComparator(itemComp);
						break;
				
			}
		}else{
			comp.addComparator(itemComp);
			
		}
	
	} while (node != null);

return query;

}
	
	public Map getCompiledQueries() {
		return compiledQueries;
	}
}
