/*
 * Created on 31-Jan-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.parser;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.introspect.ClassUtils;
import com.jofti.util.ReflectionUtil;

/**
 * @author xenephon
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AttributeValueParser {

	/**
	 * 
	 */
	
	
	
	private ClassUtils utils = new ClassUtils();
	
	//special value for primitive types
	public static final String VALUE ="VALUE"; 
	
	public AttributeValueParser() {
		
	}

	
    
    public Comparable[] constructArrayValue(Object unParsedValues, ClassIntrospector introspector, Class name, String attribute, Map parameters) throws JoftiException
    {
    	
    	// we can either have a string that is a key to a named attribute or a list
    	boolean fromObject=false;
    	Collection values =null;
    	
    	if (unParsedValues.getClass() == String.class ){
    		if (isParam((String)unParsedValues)){
        		
        		Object obj = constructFromParameters((String) unParsedValues, parameters);
        		
        		if (obj == null){
        			
	                throw new JoftiException("Value NULL is not valid for use with IN operator  "+ parameters);
        		}
        		
	        	if (! (obj instanceof Collection)){
	        		throw new JoftiException ("Parameter "+ unParsedValues + " must be an instance of a Collection");
	        	}
	        	values = (Collection)obj;
        		
        		fromObject =true;
    		}
    	}else{
    		values = (Collection)unParsedValues;
    	}
        // construct the value
        Comparable[] returnValues =null;
        try {
            if (values != null && values.size() != 0){  
                Class clazz =introspector.getClassForAttribute(name, attribute);
                int size = values.size();
                returnValues = new Comparable[size];
                if (clazz.isArray()){
                	clazz = clazz.getComponentType();
                }
                Iterator it = values.iterator();
                for (int i=0;i<size;i++){ 
                	Object obj = it.next();
                    	if (fromObject){
                    		if (checkType(clazz, obj)){
                    		    returnValues[i]= (Comparable)obj;    
                    		}else{
                    			throw new JoftiException("Type for parameter "+ obj + " does not match required type " + clazz + " in parameter " + unParsedValues);
                    		}
                    	}else{
                    	    returnValues[i]= changeValueType(clazz, (String)obj); 
                            
                    	}  
                }
                
            }else{
            	// return an empyt array if values is empty
                returnValues = new Comparable[1];
            }
            
        } catch (Exception e){
            throw new JoftiException(e);
        }
        return returnValues;
    }
    
    public Comparable changeValueType(Class className,  String value ) throws JoftiException{
		
			
			return (Comparable) ReflectionUtil.constructObjectValue(className,value);
		}
	
	 public Comparable constructForIsNot(String unParsedValue,  Map namedParameters) throws JoftiException
     {
	 	//this only allows nulls
	 		Object value = (Comparable)constructFromParameters(unParsedValue, namedParameters);
	 		// check value is null 
	 		try {
		 		if (value == null ||( "null".equalsIgnoreCase((String)value))){
		 			return null;
		 		}
	 		} catch (ClassCastException e){
	 			//we can ignore this here
	 		}
			throw new JoftiException("only NULL can be used with operator IS or NOT");
		 	
     
     }
 public Comparable constructValue(String unParsedValue, ClassIntrospector introspector, Class name, String attribute, Map namedParameters) throws JoftiException
 {
     // construct the value
		Object value =null;
		Class clazz =null;
		try {
         if (unParsedValue != null){
         	
         	// see if it is a named or positional query first
				
				if (isParam(unParsedValue) ){
					value = constructFromParameters(unParsedValue, namedParameters);
	                if (value ==null){
	                	throw new JoftiException("Value null is only allowed with IS or NOT operators "+ namedParameters);
	                }
	                clazz =introspector.getClassForAttribute(name, attribute);
	                if (!checkType(clazz, value)){
	                	throw new JoftiException("Parameter type "+ value.getClass() + " is not valid for parameter '"+ unParsedValue + "' requires assignable type of "+ clazz);
	                }
	         		     
				}else {
					// string attribute check from unparsed value
					clazz =introspector.getClassForAttribute(name, attribute);
	                if (clazz.isArray()){
	                    value = changeValueType(clazz.getComponentType(), unParsedValue); 
	                }else{
	                	value = changeValueType(clazz, unParsedValue);
	                }
         	}
				

         }
		} catch (Exception e){
			throw new JoftiException(e);
		}
     return (Comparable)value;
 }

	public Object constructFromParameters(String unParsedValue, Map parameters) throws JoftiException{
		
		Object value =null;
		// get the char at pos 0
		char tempChar = unParsedValue.charAt(0);
		
		// see if starts with allowed value
    	if (tempChar== ':' || tempChar == '?' ){
    		value = parameters.get(unParsedValue.substring(1));
    		if (value == null){
    			if (parameters.containsKey(unParsedValue.substring(1))){
    				return null;
    			}
    			throw new JoftiException("Parameter "+ unParsedValue + " is not in parameter set "+ parameters);
    		}else{
    			// check return type compatability here
    			
    			value =utils.wrapObject(value);
    		}
    	}
    	//return null if we do not have matching prefix
    	// or value from map (which could also be null)
    	
    	return value;
	}
	
	protected boolean isParam(String value){
		if (value ==null)
		{
			return false;
		}else {
		char tempChar = value.charAt(0);
    	if (tempChar== ':' || tempChar == '?' ){
    		return true;
    	}else{
    		return false;
    	}
	}
	}
	
	protected boolean checkType(Class clazz, Object value){
		return clazz.isAssignableFrom(value.getClass()) && Comparable.class.isAssignableFrom(clazz);
	}
	
	
	   public Comparable[] processVals(String val, Map namedParameters) throws JoftiException{
    	String value = (String)constructFromParameters(val, namedParameters);
       
    	if (value == null){
    		value = val;
    	}
        Comparable[] comp = new Comparable[2];
        comp[0] = value.substring(0,value.length()-1);
        comp[1] = ((String)comp[0]) + Character.MAX_VALUE;
        return comp;
        
    }
}
