package com.jofti.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import antlr.collections.AST;

import com.jofti.api.IndexQuery;
import com.jofti.core.INameSpaceAware;
import com.jofti.core.IParsedQuery;
import com.jofti.core.IPredicate;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.parser.sql.SQLQueryParser;
import com.jofti.query.EJBQuery;
import com.jofti.query.SQLQuery;
import com.jofti.util.ReflectionUtil;

public class NativeQueryParser extends AbstractParser implements IQueryParser  {

	
	 private static Log log =  LogFactory.getLog(ParserManager.class);
	 

	 
	public NativeQueryParser(final int cachedQueries,ClassIntrospector introspector){
		super(cachedQueries,introspector);
	 }
	 
   public NativeQueryParser(ClassIntrospector introspector){
			this(100, introspector);
		 }
	
   public IParsedQuery parseQuery(IndexQuery originalQuery)
	throws JoftiException {
       try{
   		return parseQuery(((SQLQuery)originalQuery).getQuery(),originalQuery);
       } catch (ClassCastException ce){
           throw new JoftiException("Class Query is no longer supported - use SQLQuery");
       }
   }
   
   
   public IParsedQuery  getQuery(String name){

	ParsedQuery query = null;
	synchronized (lockObject) {
		query = (ParsedQuery) compiledQueries.get(name);
	}
	if (query != null){
		SQLQueryWrapper wrapper = new SQLQueryWrapper(query);


		return wrapper;
	}
	return query;

}
   		
   public IParsedQuery parseQuery(String name, IndexQuery originalQuery)
	throws JoftiException {

// get text string
SQLQuery tempQuery = (SQLQuery) originalQuery;


ParsedQuery parsedQuery = null;

//see if query is already cached - this ignores parameters - and only checks the String format
synchronized (lockObject) {
	parsedQuery = (ParsedQuery) compiledQueries.get(name);
}

// we have a cached query here
if (parsedQuery == null) {			
	// we have to parse the query
	if (log.isDebugEnabled()) {
		log.debug("parsing new query " + ((SQLQuery) originalQuery).getQuery());
	}
	// parse the query
	
	parsedQuery = parseQuery(new ParsedQuery(), tempQuery);
	
	//add returned query into cache
	synchronized (lockObject) {
		compiledQueries.put(name, parsedQuery);
	}
}

SQLQueryWrapper wrapper = new SQLQueryWrapper(parsedQuery);

//add in the name parameters if we have any

return wrapper;


}


	 public ParsedQuery parseQuery(ParsedQuery parsedQuery, IndexQuery originalQuery) throws JoftiException{
			
	        
	    
	 		String query =((SQLQuery) originalQuery).getQuery();
			// first get an input Steam 
			Reader input =null;
			try {
			input = new StringReader(query);
			
			CommonLexer lexer = new CommonLexer(input);
			
			SQLQueryParser parser = new SQLQueryParser(lexer);
			parser.statement();
			
			
			// get the AST
			AST orderStatement =null;
			AST ast = parser.getAST();
			AST selectStatement = null;

		
			if ( ast == null || ast.getFirstChild() == null){
				
				throw new JoftiException("SQLQuery statement '" + formatQueryForError(query) + "' is not of format 'select <classname(s)> [from <namespace>] where <condition(s)>'");
			}
			if (log.isDebugEnabled()){
			    log.debug(ast.toStringTree());
	         }
			AST expression =null;
			// first try and process order
			if (ast.getType() == CommonLexerTokenTypes.ORDER){
				orderStatement =ast;
				//mark for later
				ast = ast.getFirstChild();
			}
			
			
			if (ast.getFirstChild().getType() == CommonLexerTokenTypes.FROM){
				String nameSpace = parseNameSpace(ast.getFirstChild().getFirstChild().getNextSibling());
				
				if (originalQuery instanceof INameSpaceAware){
					((INameSpaceAware)originalQuery).setNameSpace(nameSpace);
				}
				parsedQuery.setNameSpace(nameSpace);
				selectStatement = ast.getFirstChild().getFirstChild();
				expression = ast.getFirstChild().getNextSibling();
			}else{
				selectStatement = ast.getFirstChild();
				// now get the stuff out of the where clause
				
				 expression = selectStatement.getNextSibling();
			}
			
			// get the classes from here
			AST classes= selectStatement.getFirstChild();
			if (classes == null){
				throw new JoftiException("SQLQuery must contain a single className with no alias or every className must have an alias in query:"+ formatQueryForError(query));

			}
			
			parsedQuery = parseClasses(classes, parsedQuery);
			

			// we have classes and aliases
			
			// set a number of return classes
			if(parsedQuery.getAliasMap() != null && parsedQuery.getAliasMap().size()>0){
				Iterator it = parsedQuery.getAliasMap().values().iterator();
				int size =parsedQuery.getAliasMap().size();
				for (int i = 0;i<size;i++){
					Object obj = it.next();
					parsedQuery.getFieldReturnMap().put(obj,null);
				}
			}

			
	        if (log.isDebugEnabled()){

			log.debug(expression.getText());
	        }
			
			Stack stack = new Stack();
			
			stack = parseWherePredicates(expression,stack,parsedQuery);
	        
	         if (log.isDebugEnabled()){
	             log.debug(stack);
	         }
			
			// we need to reverse the stack here
			Stack temp = new Stack();
			
			boolean predicateElement =false;
			
			while (stack.size() !=0){
				Object obj = stack.pop();
				if (predicateElement){
					if (obj instanceof IPredicate){
						throw new JoftiException("SQLQuery not formatted correctly a join operator must seperate two predicates");
					} 
					predicateElement =false;
				} else{
					if (obj instanceof Operator){
						throw new JoftiException("SQLQuery not formatted correctly a join operator must seperate two predicates");		
					} 
					predicateElement =true;
				}
				temp.push(obj);
			}

			
			parsedQuery.setPredicates(temp);
			
			if (orderStatement != null){
				parsedQuery = parseOrder(orderStatement, parsedQuery);
			}
			} catch (Throwable t){
				if (t instanceof JoftiException){
					throw (JoftiException)t;
				}else{
					throw new JoftiException("SQLQuery statement '" + formatQueryForError(query) + "' is not of format 'select <classname(s)> where <condition(s)>'",t);
				}
				
			}finally {
				try {
					if (input != null){
						input.close();
					}
				} catch (IOException e){
					// we do not care here
				}
			}
			
			
			return parsedQuery;
			
			
		}

	   
	
		
		private String parseNameSpace(AST expression) throws JoftiException{
			
			String nameSpace ="";
			while (expression != null){

					nameSpace = nameSpace + expression.getText();
				expression = expression.getNextSibling();
				
			}
	        if (log.isDebugEnabled()){
	            log.debug("name space:" + nameSpace);
	        }
			return nameSpace;
		}

	

		
		private ParsedQuery parseClasses(AST classes, ParsedQuery query) throws JoftiException{
			//first check if classes has any children as this tells us if as has been used
			AST node = classes;
			if (node.getType() != CommonLexerTokenTypes.ALIAS_IDENTIFIER){
				Class clazz = null;
				try{
					clazz = ReflectionUtil.classForName(node.getText());
				}catch (Exception e){
					throw new JoftiException("Class "+ node.getText() + " cannot be constructed in query",e);
				}
				query.setClassName(clazz);
			}else{
				do{
					// we have some alias
	                if (log.isDebugEnabled()){
					log.debug("alias found for class " + node.getFirstChild().toStringTree() + " of " +node.getFirstChild().getNextSibling().toStringTree());
	                }
	                Class clazz =null;
                    try {
                    	clazz = ReflectionUtil.classForName(node.getFirstChild().getText());
                    } catch (Exception e){
                    	throw new JoftiException("Class "+ node.getFirstChild().getText() + " cannot be parsed in query",e);
                    }
	                query.getAliasMap().put(node.getFirstChild().getNextSibling().getText(),clazz );
				    node = node.getNextSibling();
				}while (node != null);
			}
			return query;
			
			
		}
		
		private String formatQueryForError(String query){
			if (query.lastIndexOf(";") != query.length()){
				return query.substring(0,query.length()-1);
			}else{
				return query;
			}
		}

}
