/*
 * Created on 17-Jul-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import com.jofti.api.IndexQuery;
import com.jofti.core.INameSpaceAware;
import com.jofti.core.IParsedQuery;
import com.jofti.core.QueryId;
import com.jofti.core.QueryType;
import com.jofti.util.CompositeComparator;

/**
 * 
 * 
 * Implementation of the IParsedQuery.
 * 
 * @author xenephon (xenephon@jofti.com)
 */
public class ParsedQuery implements IParsedQuery, IndexQuery, INameSpaceAware, QueryId {

	
	private Class className;
	private Map aliasMap = new HashMap();
	
	private Map namedValueMap = null;
	private Stack predicates = new Stack();
	 
	private Object nameSpace =null;
    
    private Map fieldReturnMap = new LinkedHashMap();
    
    private CompositeComparator orderingComp = new CompositeComparator();
	
	private int classes; 
	
	private int maxResults;
	
	private int firstResult;
	
    static final QueryType QUERY_ID =QueryType.PARSED_QUERY;
    
	public Class getClassName() {
		return className;
	}
	public void setClassName(Class className) {
		this.className = className;
	}
	public Map getAliasMap() {
		return aliasMap;
	}
	public void setAliasMap(Map aliasMap) {
		this.aliasMap = aliasMap;
	}
	/**
	 * @return Returns the predicates.
	 */
	public synchronized Stack getPredicates() {
		return predicates;
	}
	/**
	 * @param predicates The predicates to set.
	 */
	public synchronized void setPredicates(Stack predicates) {
		this.predicates = predicates;
	}
	public int getClasses() {
		return classes;
	}
	public void setClasses(int classes) {
		this.classes = classes;
	}
	public Object getNameSpace() {
		return nameSpace;
	}
	
	public void setNameSpace(Object nameSpace) {
		this.nameSpace = nameSpace;
		
	}
    public QueryType getQueryType()
    {
        // TODO Auto-generated method stub
        return QUERY_ID;
    }
    /**
     * @return Returns the fieldReturnMap.
     */
    public Map getResultFieldsMap()
    {
        return fieldReturnMap;
    }
    /**
     * @param fieldReturnMap The fieldReturnMap to set.
     */
    public void setResultFieldsMap(Map fieldReturnMap)
    {
        this.fieldReturnMap = fieldReturnMap;
    }
	
	public Map getFieldReturnMap() {
		return fieldReturnMap;
	}
	public void setFieldReturnMap(Map fieldReturnMap) {
		this.fieldReturnMap = fieldReturnMap;
	}
	public Map getNamedValueMap() {
		return namedValueMap;
	}
	public void setNamedValueMap(Map namedValueMap) {
		this.namedValueMap = namedValueMap;
	}
	/* (non-Javadoc)
	 * @see com.jofti.api.IndexQuery#setParameter(java.lang.String, java.lang.Object)
	 */
	public IndexQuery setParameter(String name, Object value) {
		namedValueMap.put(name, value);
		return this;
	}
	/* (non-Javadoc)
	 * @see com.jofti.api.IndexQuery#setParameter(int, java.lang.Object)
	 */
	public IndexQuery setParameter(int position, Object value) {
		namedValueMap.put(""+position, value);
		return this;
	}
	public CompositeComparator getOrderingComparator() {
		return orderingComp;
	}
	public void setOrderingComparator(CompositeComparator orderingComp) {
		this.orderingComp = orderingComp;
	}
	public IndexQuery setMaxResults(int maxResults) {
		this.maxResults = maxResults;
		return this;
	}
	public IndexQuery setFirstResult(int firstResult) {
		this.firstResult = firstResult;
		return this;
	}
	public int getFirstResult() {
		return firstResult;
	}
	public int getMaxResults() {
		return maxResults;
	}
}
