/*
 * Created on 17-Jul-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.parser;

import com.jofti.api.IndexQuery;
import com.jofti.core.IParsedQuery;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.query.EJBQuery;
import com.jofti.query.SQLQuery;

/**
 * @author xenephon (xenephon@jofti.com)
 *
 */
public class ParserManager {

	 
	 
     private IQueryParser nativeQueryParser = null;
     private IQueryParser ejb3QueryParser = null;

	 public ParserManager(ClassIntrospector introspector){
		 nativeQueryParser = new NativeQueryParser(introspector);
         ejb3QueryParser = new EJBQueryParser(introspector);
		 }
	 
	/**
	 * Parses a String representation of a query. Uses the SimpleQuery Parser.
	 * 
	 * @param originalQuery
	 * @return the parsed query
	 * @throws JoftiException
	 */
	 public IParsedQuery parseQuery(IndexQuery originalQuery) throws JoftiException{
		if (originalQuery instanceof EJBQuery){
			return ejb3QueryParser.parseQuery(originalQuery);
		}else if (originalQuery  instanceof SQLQuery) {
			return nativeQueryParser.parseQuery(originalQuery);
			
		}else{
			return new ConvenienceQueryWrapper(originalQuery);
		}
		
		
	 }
	 
	 public IndexQuery addQuery(String name, IndexQuery originalQuery) throws JoftiException{
	 	
		if (originalQuery instanceof EJBQuery){
			return ejb3QueryParser.parseQuery(name,originalQuery);
		}else if (originalQuery instanceof SQLQuery){
			return nativeQueryParser.parseQuery(name, originalQuery);
		} else{
	 		throw new JoftiException("Only " + EJBQuery.class + " or " + SQLQuery.class + " are allowed to be added");
	 		
		}
		
	 }
	 
	 public IndexQuery addQuery(String name, String query) throws JoftiException{
	 	
		return addQuery(name, new EJBQuery(query));
		
	 }
	 public IndexQuery getQuery(String name){
	 	IndexQuery query = ejb3QueryParser.getQuery(name);
	 	if (query ==null){
	 		query = nativeQueryParser.getQuery(name);
	 	}
	 	return query;
	 }

}
