package com.jofti.plugin;

import java.util.Properties;

import com.ibm.websphere.objectgrid.BackingMap;
import com.ibm.websphere.objectgrid.ObjectGrid;
import com.ibm.websphere.objectgrid.ObjectGridException;
import com.ibm.websphere.objectgrid.ObjectGridManager;
import com.ibm.websphere.objectgrid.ObjectGridManagerFactory;
import com.ibm.websphere.objectgrid.ObjectGridRuntimeException;
import com.ibm.websphere.objectgrid.TxID;
import com.ibm.websphere.objectgrid.plugins.LogSequence;
import com.ibm.websphere.objectgrid.plugins.index.MapIndexInfo;
import com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin;
import com.jofti.api.IndexManager;
import com.jofti.cache.adapter.ObjectGridListenerAdapter;
import com.jofti.cache.adapter.listener.ObjectGridEventListener;
import com.jofti.config.DefaultIndexConfig;
import com.jofti.exception.JoftiException;
import com.jofti.manager.IndexManagerImpl;

/**
 * <p>
 * Implementation of ObjectGrid's MapIndexPlugin. The implmentation configures itself lazily on either the first 
 * call to getIndexProxy or the first commit callback.
 * </p>
 * <p>
 * Due to the information passed into the Plug-In it is also necessary to configure the GridName and the BackingMapName.
 * </p>
 * @author steve
 * @version 1.1
 * @since 1.2
 *
 */
public class ObjectGridIndexPlugIn implements MapIndexPlugin{

	
	IndexManager manager = new IndexManagerImpl();
	DefaultIndexConfig config = new DefaultIndexConfig();
	private boolean started = false;
	private String configFile =null;
	private String backingMapName =null;
	private String gridName =null;
	
	ObjectGridEventListener listener =null;
	
	
	public ObjectGridIndexPlugIn(){
			
		config = new DefaultIndexConfig();
		Properties props = new Properties();
		props.put("plugin", "true");
		config.setAdapterProperties(props);
		config.setCacheAdapter("com.jofti.cache.adapter.ObjectGridListenerAdapter");
		 
	}
	
	public void setName(String name){
		config.setName(name);
	
	}
	
	public void setConfigFile(String fileName){
		this.configFile = fileName;
	}
	
	public void setGridName(String name){
		this.gridName =name;
	}
	
	public void setBackingMapName(String name){
		this.backingMapName = name;
	}
	private synchronized void init(String objectGridName, String mapName) throws JoftiException{
		
		if (!started){
			System.out.println("initialising");
			ObjectGridManager oGridManager= 
				 ObjectGridManagerFactory.getObjectGridManager(); 
			ObjectGrid grid = oGridManager.getObjectGrid(objectGridName);
			
			if (grid == null){
				throw new JoftiException("Unable to find grid:"+objectGridName);
			}
			BackingMap map = grid.getMap(mapName);
			
			if (map ==null){
				throw new JoftiException("Unable to find map:"+mapName);
			}
			if (config.getName() == null){
				throw new JoftiException("Index name cannot be null");
			}
			ObjectGridListenerAdapter adapter =null;
			if (configFile != null){
				adapter = (ObjectGridListenerAdapter) manager.addIndex(config,map,configFile );
			}else{
				adapter = (ObjectGridListenerAdapter)manager.addIndex(config, map);
			}
			
			listener = adapter.getEventListener();
			started =true;
		}
	}
	
	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#doBatchUpdate(com.ibm.websphere.objectgrid.TxID, com.ibm.websphere.objectgrid.plugins.LogSequence)
	 */
	public void doBatchUpdate(TxID txid, LogSequence logsequence) throws ObjectGridRuntimeException {
		
		try {
			init(logsequence.getObjectGridName(), logsequence.getMapName());
		}catch (JoftiException e){
			throw new ObjectGridRuntimeException(e);
		}
		listener.doBatchUpdate(txid, logsequence);
		
	}

	/* (non-Javadoc)
	 * @see com.ibm.websphere.objectgrid.plugins.index.MapIndexPlugin#getIndexProxy(com.ibm.websphere.objectgrid.plugins.index.MapIndexInfo)
	 */
	public Object getIndexProxy(MapIndexInfo mapindexinfo) {
		
		if (!started && (gridName == null || backingMapName ==null)){
			throw new RuntimeException("gridname and backingMap name must be set in Plug-In config");
		}
		
		try {
			init(gridName, backingMapName);
		}catch (JoftiException e){
			throw new ObjectGridRuntimeException(e);
		}
		return listener.getIndexProxy(mapindexinfo);
	}

	public String getName() {
		return config.getName();
	}

	public void setAttributeName(String s) {
		// we do not care here 
	}

	public void undoBatchUpdate(TxID txid, LogSequence logsequence) throws ObjectGridException {
		listener.undoBatchUpdate(txid, logsequence);
		
	}

}
