package com.jofti.query;

import com.jofti.api.IndexQuery;
import com.jofti.core.QueryId;
import com.jofti.core.QueryType;
import com.jofti.util.ReflectionUtil;

/**
 * 
 *
* A utility class to enable simple queries to be done easily. The Query matches  
* ranges  for particular field. This is equivalent to (>= and <=) or (> and <).<p>
 * 
 * 
 * This query cannot be combined with any other. iF you want to construct more complex queries use the @link com.jofti.query.Query class.
 <p>
 * @author steve Woodcock
 */

public class MatchRangeQuery implements IndexQuery, QueryId {

	public final Object alias;
	int hashCode =0;
	Class className;
	String propertyName;
	Comparable startValue;
	Comparable endValue;
	boolean inclusive =true;
    
     static final QueryType QUERY_ID=QueryType.RANGE_QUERY;
	
	/**
	 * Construct a query supplying the classname of the object type to be returned, the field to be queried and the start and finish values to be used. 
	 * <p>
	 * The field type in the object and the values must be of the same type. In addition the end value must
	 * be greater (comparaison >0 ) than the start value;
	 * <p>
	 * An example usage would be:
	 * <p>
	 * new MatchNSQuery(org.package.Myclass.class, "myProperty" ,10,20);
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param startValue - the value that is used as the start search value.
	 * @param endValue - the value that is used as the end search value.
	 */
     public MatchRangeQuery(Class className, String propertyName, Comparable startValue,Comparable endValue){
		this(className,propertyName,startValue,endValue,null);
	}
     
	public MatchRangeQuery(Class className, String propertyName, Comparable startValue,Comparable endValue,Object alias){
		this.className = className;
		this.propertyName = propertyName;
		this.startValue = startValue;
		this.endValue = endValue;
		this.alias = alias;
	}
	
	/**
	 * Construct a query supplying the classname of the object type to be returned, the field to be queried and the start and finish values to be used. 
	 * <p>
	 * The field type in the object and the values must be of the same type. In addition the end value must
	 * be greater (comparaison >0 ) than the start value;
	 * <p>
	 * An example usage would be:
	 * <p>
	 * new MatchNSQuery("org.package.Myclass", "myProperty" ,10,20);
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param startValue - the value that is used as the start search value.
	 * @param endValue - the value that is used as the end search value.
	 */
	public MatchRangeQuery(String className, String propertyName, Comparable startValue,Comparable endValue){
		this(className,propertyName,startValue,endValue,null);
	}
	public MatchRangeQuery(String className, String propertyName, Comparable startValue,Comparable endValue,Object alias){
		Class clazz = null;
		try{
			clazz = ReflectionUtil.classForName(className);
		}catch (Exception e){
			throw new RuntimeException(e);
		}
		this.className = clazz;
		this.propertyName = propertyName;
		this.startValue = startValue;
		this.endValue = endValue;
		this.alias =alias;
	}
	/**
	 * Construct a query supplying the classname of the object type to be returned, the field to be queried and the start and finish values to be used. 
	 * <p>
	 * The field type in the object and the values must be of the same type. In addition the end value must
	 * be greater (comparaison >0 ) than the start value. thi method also allows the setting of search inclusivity.
	 * <p>
	 * An example usage would be:
	 * <p>
	 * new MatchNSQuery(org.package.Myclass.class, "myProperty" ,10,20, true);
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param startValue - the value that is used as the start search value.
	 * @param endValue - the value that is used as the end search value.
	 * @param inclusive - whether a search is inclusive of values
	 */
	public MatchRangeQuery(Class className, String propertyName, Comparable startValue,Comparable endValue,boolean inclusive){
		this(className,propertyName,startValue,endValue,null);
	}
	public MatchRangeQuery(Class className, String propertyName, Comparable startValue,Comparable endValue,boolean inclusive,Object alias){
		this.className = className;
		this.propertyName = propertyName;
		this.startValue = startValue;
		this.endValue = endValue;
		this.inclusive = inclusive;
		this.alias = alias;
	}
	
	/**
	 * Construct a query supplying the classname of the object type to be returned, the field to be queried and the start and finish values to be used. 
	 * <p>
	 * The field type in the object and the values must be of the same type. In addition the end value must
	 * be greater (comparaison >0 ) than the start value. thi method also allows the setting of search inclusivity.
	 * <p>
	 * An example usage would be:
	 * <p>
	 * new MatchNSQuery("org.package.Myclass", "myProperty" ,10,20, true);
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param startValue - the value that is used as the start search value.
	 * @param endValue - the value that is used as the end search value.
	 * @param inclusive - whether a search is inclusive of values
	 */
	public MatchRangeQuery(String className, String propertyName, Comparable startValue,Comparable endValue,boolean inclusive){
		this(className, propertyName,startValue,endValue,inclusive,null);
	}
	
	public MatchRangeQuery(String className, String propertyName, Comparable startValue,Comparable endValue,boolean inclusive,Object alias){
		Class clazz = null;
		try{
			clazz = ReflectionUtil.classForName(className);
		}catch (Exception e){
			throw new RuntimeException(e);
		}
		this.className = clazz;
		this.propertyName = propertyName;
		this.startValue = startValue;
		this.endValue = endValue;
		this.inclusive = inclusive;
		this.alias =alias;
	}
	/**
	 * Construct a query supplying the start and finish values to be used. 
	 * <p>
	 * The values must be of the same type. In addition the end value must
	 * be greater (comparaison >0 ) than the start value. This is a convenience method for classes (such as String,Integer etc)
	 * that have no property value as such. Instead the value is the class type. This method also allows the setting of search inclusivity.
	 * <p>
	 * An example usage would be:
	 * <p>
	 * new MatchRangeQuery(new Integer(10), new Integer(20), true);
	 * <p>
	 * @param startValue - the value that is used as the start search value.
	 * @param endValue - the value that is used as the end search value.
	 * @param inclusive - whether a search is inclusive of values
	 */
	public MatchRangeQuery(Comparable startValue,Comparable endValue, boolean inclusive){
		this(startValue,endValue,inclusive,null);
	}
	public MatchRangeQuery(Comparable startValue,Comparable endValue, boolean inclusive,Object alias){
		this.startValue = startValue;
		this.endValue = endValue;
		this.inclusive = inclusive;
		this.alias =alias;
	}
	/**
	 * @return Returns the className.
	 */
	public Class getClassName() {
		return className;
	}

	/**
	 * @return Returns the propertyName.
	 */
	public String getPropertyName() {
		return propertyName;
	}

	/**
	 * @return Returns the value.
	 */
	
	
	/**
	 * @return Returns the endValue.
	 */
	public Comparable getEndValue() {
		return endValue;
	}

	/**
	 * @return Returns the startValue.
	 */
	public Comparable getStartValue() {
		return startValue;
	}
	public boolean isInclusive() {
		return inclusive;
	}
	public void setInclusive(boolean inclusive) {
		this.inclusive = inclusive;
	}

    public QueryType getQueryType()
    {
        
        return QUERY_ID;
    }
    
 
	public Object getAlias() {
		return alias;
	}
	
	public IndexQuery setParameter(String name, Object value) {
		throw new UnsupportedOperationException("Parameters are not supported for convenience classes");
	}
	/* (non-Javadoc)
	 * @see com.jofti.api.IndexQuery#setParameter(int, java.lang.Object)
	 */
	public IndexQuery setParameter(int position, Object value) {
		throw new UnsupportedOperationException("Parameters are not supported for convenience classes");

	}

	public IndexQuery setFirstResult(int firstResult) {
		throw new UnsupportedOperationException("result limits are not supported for convenience classes");

	}
	public IndexQuery setMaxResults(int maxResults) {
		throw new UnsupportedOperationException("result limits are not supported for convenience classes");

	}
}
