package com.jofti.query;



/**
 * 
 *
 * A utility class to enable simple queries to be done easily. The Query matches everything smaller than the 
 * value passed in for that particular field. The optional inclusive flag allows the behaviour to be either <= or just <.
 * <p>
 * 
 *  This query cannot be combined with any other. iF you want to construct more complex queries use the @link com.jofti.query.Query class.
<p>
 * @author Steve Woodcock
 */
public class MatchSmallerQuery extends MatchRangeQuery {


	
    /**
	 * Construct a query supplying the classname of the object type to be returned, the 
	 *  field to be queried and the value to be used. 
	 * <p>
	 * The field type in the object and the value must be of the same type.
	 * <p>
	 * It is assumed that the search is inclusive.
	 * <p>
	 * An example usage  would be:
	 * <p>
	 * new MatchSmallerQuery(org.package.Myclass.class, "myProperty" ,"some value");
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param value - the value that is used as the search value.
	 */
	public MatchSmallerQuery(Class className, String propertyName, Comparable value){
		super(className,propertyName,null,value,null);
	}
	
	public MatchSmallerQuery(Class className, String propertyName, Comparable value,Object alias){
		super(className,propertyName,null,value,alias);
	}
	
	  /**
	 * Construct a query supplying the classname of the object type to be returned, the 
	 *  field to be queried and the value to be used. 
	 * <p>
	 * The field type in the object and the value must be of the same type.
	 * <p>
	 * It is assumed that the search is inclusive.
	 * <p>
	 * An example usage  would be:
	 * <p>
	 * new MatchSmallerQuery("org.package.Myclass", "myProperty" ,"some value");
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param value - the value that is used as the search value.
	 */
	public MatchSmallerQuery(String className, String propertyName, Comparable value){
		super(className,propertyName,null,value);
	}
	
	public MatchSmallerQuery(String className, String propertyName, Comparable value,Object alias){
		super(className,propertyName,null,value,alias);
	}
	 /**
	 * Construct a query supplying the classname of the object type to be returned, the 
	 *  field to be queried and the value to be used. This method allows inclusivity to be set.
	 * <p>
	 * The field type in the object and the value must be of the same type.
	 * <p>
	 * It is assumed that the search is inclusive.
	 * <p>
	 * An example usage  would be:
	 * <p>
	 * new MatchSmallerQuery("org.package.Myclass", "myProperty" ,"some value");
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param value - the value that is used as the search value.
	 * @param inclusive - whether the search should be inclusive.
	 */
	public MatchSmallerQuery(Class className, String propertyName, Comparable value, boolean inclusive){
		super(className,propertyName,null,value, inclusive);
	}
	
	public MatchSmallerQuery(Class className, String propertyName, Comparable value, boolean inclusive,Object alias){
		super(className,propertyName,null,value, inclusive,alias);
	}
	
	public MatchSmallerQuery(String className, String propertyName, Comparable value, boolean inclusive){
		super(className,propertyName,null,value, inclusive);
	}
	
	public MatchSmallerQuery(String className, String propertyName, Comparable value, boolean inclusive,Object alias){
		super(className,propertyName,null,value, inclusive,alias);
	}
	/**
	 * Construct a query supplying the value to be searched against. 
	 * This is a convenience method for classes (such as String,Integer etc)
	 * that have no property value as such. Instead the value is the class type.
	 * <p>
	 * 
	 * An example usage would be:
	 * <p>
	 * new MatchSmallerQuery("some value",true);
	 * <p>
	 * This is so you do not have to use the methods above in the manner of
	 * <p>
	 * new MatchSmallerQuery("java.lang.String",  null ,"some value"); 
	 * 
<p>
	 * @param value - the value that is used as the search value.
	 * @param inclusive - indicates if the value is to be inclusive in range.
	 */
	public MatchSmallerQuery(Comparable value, boolean inclusive){
		super(null,value, inclusive);
	}
	
	public MatchSmallerQuery(Comparable value, boolean inclusive,Object alias){
		super(null,value, inclusive,alias);
	}
	
}
