/*
 * Created on 13-Jul-2005
 *
 */
package com.jofti.query;

import com.jofti.api.IndexQuery;
import com.jofti.core.QueryId;
import com.jofti.core.QueryType;

/**
 * 
 *
 * Basic usage is "select ${classname} where ${propertyname} [=,<,>,!=,>=,<=] 'value'"
 * <p>
 * multiproperty queries are of the form<br>
 * "select ${classname} where ${propertyname} [=,<,>,!=,>=,<=] 'value' [and,or] ${propertyname} [=,<,>,!=,>=,<=] 'value'"
 * <p>
 * compound queries are supported as ${query} [and,or] ${query}
 * <p>
 * ordering for compound queries is achieved through use of bracket groups<br>
  * "select ${classname} where ($propertyname} [=,<,>,!=,>=,<=] 'value' [and,or] ${propertyname} [=,<,>,!=,>=,<=] 'value') [and,or] ${propertyname} [=,<,>,!=,>=,<=] 'value'"
  <p>
 * 
 * multiclass queries are of the form
 * <p>
 * select ${classname} as A, ${classname} as B where A.${propertyname} [=,<,>,!=,>=,<=] 'value' [and.or] B.${propertyname}  [=,<,>,!=,>=,<=] 'value'"
 * <p>
 * 
 * All values are created using a reflective String constructor .So if you want to Compare an Integer(22) you just specify
 * value=22  - the value type is chosen based on the declared type of the field.
 * <p>
 * For primitive wrappers in the JVM the propertyname is always the literal string 'VALUE' (case insensitive)
 * * 		<li>
 * 			java.lang.String.class,
    		java.lang.Integer.class,
    		java.lang.Double.class,
    		java.lang.Float.class,
    		java.lang.Long.class,
    		java.lang.Short.class,
    		java.math.BigInteger.class,
    		java.math.BigDecimal.class,
    		java.util.Date.class,
    		java.net.URI.class 
    		</li>  
 * <p>
 * For example to query an integer you would write
 * <p>
 * select java.lang.Integer where VALUE = 20
 * <p>
 * or <br>
 * select java.lang.Integer as i where i.VALUE =20
 * <p>
 * 
 * Dates are constructed using the default encoding of the JVM. So a UK encoding would be:
 * <p>
 * select java.util.Date where value <='4/10/1901 00:00:00' 
 * <p>
 * For user defined classes in order to query the property type must have a String constructor and must 
 * implement equals and hashCode correctly.
 *  <p>
 *  
 *  @author Steve Woodcock
 *  @version 1.0
 */
public class SQLQuery implements IndexQuery, QueryId {

	int hashCode =0;
	String query = null;
     static final QueryType QUERY_ID=QueryType.UNPARSED_QUERY;
     
	private static final String TERMINATOR =";";
	
	public SQLQuery(String query){
		this.query = query + TERMINATOR;
	}
	
	public String getQuery(){
		return this.query;
	}

    public QueryType getQueryType()
    {
        return QUERY_ID;
    }
    
    public int hashCode(){
    	if (hashCode ==0){
    		hashCode = query.hashCode();
    	}
    	return hashCode;
    }
    
    public boolean equals(Object obj){
    	return query.equals(obj);
    }
    
	public IndexQuery setParameter(String name, Object value) {
		throw new UnsupportedOperationException("Parameters are not supported for sql queries");
	}
	/* (non-Javadoc)
	 * @see com.jofti.api.IndexQuery#setParameter(int, java.lang.Object)
	 */
	public IndexQuery setParameter(int position, Object value) {
		throw new UnsupportedOperationException("Parameters are not supported for sql queries");

	}
	
	public IndexQuery setFirstResult(int firstResult) {
		throw new UnsupportedOperationException("result limits are not supported for sql queries");

	}
	public IndexQuery setMaxResults(int maxResults) {
		throw new UnsupportedOperationException("result limits are not supported for sql queries");

	}
}
