package com.jofti.query.namespace;

import com.jofti.api.IndexQuery;
import com.jofti.core.QueryId;
import com.jofti.core.QueryType;
import com.jofti.util.ReflectionUtil;

/**
 * 
 *
 * A utility class to enable simple queries to be done easily. The Query matches everything equal to the 
 * value passed in for that particular field. This is equivalent to =.<p>
 * 
 * 
 *  This query cannot be combined with any other. iF you want to construct more complex queries use the @link com.jofti.query.Query class.
  *<p>
  *@author Steve Woodcock
 */
public class MatchNSInQuery implements IndexQuery, QueryId {

	Class className;
	String propertyName;
	Comparable[] values;
	Object nameSpace;
	public final Object alias;
	
    static final QueryType QUERY_ID=QueryType.IN_NS_QUERY;
	
	/**
	 * Construct a query supplying the classname of the object type to be returned,and the 
	 * field to be queried and the value to be used. <p>
	 * 
	 * The field type in the object and the value must be of the same type.
	 * 
	 * <p>
	 * An example usage  would be:
	 * <p>
	 * new MatchQuery("org.package.Myclass", "myProperty" ,"some value");
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param propertyName - the field name to use
	 * @param value - the value that is used as the search value.
	 */
	public MatchNSInQuery(Class className, Object nameSpace, String propertyName, Comparable[] values){
		this(className,nameSpace, propertyName,values,null);
	}
	public MatchNSInQuery(Class className, Object nameSpace, String propertyName, Comparable[] values,Object alias){
		this.className = className;
		this.nameSpace = nameSpace;
		this.propertyName = propertyName;
		this.values = values;
		this.alias = alias;
	}
	
	public MatchNSInQuery(String className, Object nameSpace, String propertyName, Comparable[] values){
		this(className,nameSpace,propertyName,values,null);
	}
	public MatchNSInQuery(String className, Object nameSpace,String propertyName, Comparable[] values,Object alias){
		Class clazz = null;
		try{
			clazz = ReflectionUtil.classForName(className);
		}catch (Exception e){
			throw new RuntimeException(e);
		}
		this.nameSpace = nameSpace;
		this.className = clazz;
		this.propertyName = propertyName;
		this.values = values;
		this.alias = alias;
	}
	/**
	 * Construct a query supplying the value to be searched against. 
	 * This is a convenience method for classes (such as String,Integer etc)
	 * that have no property value as such. Instead the value is the class type.
	 * <p>
	 * 
	 * An example usage  would be:
	 * <p>
	 * new MatchNotQuery("some value",true);
	 * <p>
	 * This is so you do not have to use the methods above in the manner of
	 * <p>
	 * new MatchQuery("java.lang.String", null ,"some value"); 
	 * <p>
	 * @param value - the value that is used as the search value.
	 */
	public MatchNSInQuery(Comparable[] values){
		this.values = values;
		this.alias =null;
	}
	/**
	 * @return Returns the className.
	 */
	public Class getClassName() {
		return className;
	}

	/**
	 * @return Returns the propertyName.
	 */
	public String getPropertyName() {
		return propertyName;
	}

	/**
	 * @return Returns the value.
	 */
	public Comparable[] getValues() {
		return values;
	}

    public QueryType getQueryType()
    {
        return  QUERY_ID;
    }

	
	public Object getNameSpace() {
		return nameSpace;
	}
	public void setNameSpace(Object nameSpace) {
		this.nameSpace = nameSpace;
	}
	public Object getAlias() {
		return alias;
	}
	/* (non-Javadoc)
	 * @see com.jofti.api.IndexQuery#setParameter(java.lang.String, java.lang.Object)
	 */
	public IndexQuery setParameter(String name, Object value) {
		throw new UnsupportedOperationException("Parameters are not supported for convenience classes");
	}
	/* (non-Javadoc)
	 * @see com.jofti.api.IndexQuery#setParameter(int, java.lang.Object)
	 */
	public IndexQuery setParameter(int position, Object value) {
		throw new UnsupportedOperationException("Parameters are not supported for convenience classes");

	}
	public IndexQuery setFirstResult(int firstResult) {
		throw new UnsupportedOperationException("Result limitation is not supported for convenience classes");
	}
	public IndexQuery setMaxResults(int maxResults) {
		throw new UnsupportedOperationException("Result limitation is not supported for convenience classes");
	}

}
